% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status.R
\name{selenium_server_available}
\alias{selenium_server_available}
\alias{wait_for_selenium_available}
\alias{get_server_status}
\title{Is a selenium server instance running?}
\usage{
selenium_server_available(
  port = 4444L,
  host = "localhost",
  verbose = FALSE,
  timeout = 20
)

wait_for_selenium_available(
  max_time = 60,
  port = 4444L,
  host = "localhost",
  verbose = FALSE,
  timeout = 20,
  error = FALSE
)

get_server_status(
  port = 4444L,
  host = "localhost",
  verbose = FALSE,
  timeout = 20
)
}
\arguments{
\item{port}{The port that the Selenium server is using, so we can
connect to it.}

\item{host}{The host that the Selenium server is running on. This is
usually 'localhost' (i.e. Your own machine).}

\item{verbose}{Whether to print information about the web request that is
sent.}

\item{timeout}{How long to wait for a request to recieve a response before
throwing an error.}

\item{max_time}{The amount of time to wait for the Selenium server to
become available.}

\item{error}{Whether to throw an error if the web request throws an error
after the timeout is exceeded. By default, a logical value is always
returned.}
}
\value{
\code{selenium_server_available()} returns \code{TRUE} if a Selenium server is
running, and \code{FALSE} otherwise, and \code{wait_for_selenium_available()} returns
the same thing.

\code{get_server_status()} returns a list that can (but may not always) contain
the following fields:
\itemize{
\item \code{ready}: Whether the server is ready to be connected to. This should
always be returned by the server.
\item \code{message}: A message about the status of the server.
\item \code{uptime}: How long the server has been running.
\item \code{nodes}: Information about the slots that the server can take.
}
}
\description{
\code{selenium_server_available()} returns \code{TRUE} if a Selenium server is
running on a given port and host. \code{wait_for_selenium_available()} waits
for the Selenium server to become available for a given time.

\code{get_server_status()}, when given a port and host, figures out whether a
Selenium server instance is running, and if so, returns its status. This is
used by \code{selenium_server_available()} to figure out if the server is
running.
}
\examples{
\dontrun{
get_server_status()

selenium_server_available()

wait_for_selenium_available()
}

}
