% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navigation.R, R/navigationDoc.R
\name{getTitle}
\alias{getTitle}
\title{Get the current page title.}
\usage{
getTitle(remDr, ...)
}
\arguments{
\item{remDr}{An object of class "rDriver". A remote driver object see \code{\link{remoteDr}}.}

\item{...}{Additonal function arguments - Currently passes the \code{\link{retry}} argument.}
}
\value{
The title of the current page is returned as a character string.
}
\description{
\code{getTitle} Get the current page title.
}
\examples{
\dontrun{
  remDr <- remoteDr()
  remDr \%>\% go("http://www.google.com/ncr")

  # get the title
  remDr \%>\% getTitle

  # get the current page url
  remDr \%>\% getCurrentUrl

  # navigate
  remDr \%>\% go("http://www.bbc.co.uk")

  # go back
  remDr \%>\% (seleniumPipes::back)

  # go forward
  remDr \%>\% forward

  # refresh page
  remDr \%>\% refresh

  # close browser
  remDr \%>\% deleteSession
}

}
\seealso{
Other navigation functions: \code{\link{back}},
  \code{\link{forward}}, \code{\link{getCurrentUrl}},
  \code{\link{go}}, \code{\link{refresh}}
}

