% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{genData.RK}
\alias{genData.RK}
\title{genData.RK}
\usage{
genData.RK(
  N = NULL,
  Sigma = NULL,
  nSets = 1,
  distributions = NULL,
  modelH0 = NULL,
  maxIter = 10
)
}
\arguments{
\item{N}{sample size.}

\item{Sigma}{population covariance matrix.}

\item{nSets}{number of data sets to generate}

\item{distributions}{a list specifying the population distribution and  additional arguments in a list either to apply to all variables (e.g. \code{list(rchisq, list(df = 2))}) or a list of lists specifying the distributions for each variable. See examples.}

\item{modelH0}{a \code{lavaan} model string, only used to determine the number of factors.}

\item{maxIter}{maximum number of iterations, defaults to 10.}
}
\value{
Returns the generated data
}
\description{
Generates random data conforming to a population variance-covariance matrix using
the approach by Ruscio & Kaczetow (2008)
specifying distributions for the marginals.
}
\details{
This function is based on the implementation by Ruscio & Kaczetow (2008).

For details, see
Ruscio, J., & Kaczetow, W. (2008). Simulating multivariate nonnormal data using an iterative algorithm. \emph{Multivariate Behavioral Research, 43}, 355-381.
}
\examples{
\dontrun{
distributions <- list(
  list('rchisq', list(df = 2)),
  list('runif', list(min = 0, max = 1)),
  list('rexp', list(rate = 1))
)
data <- genData.ruscio(N = 100, Sigma = diag(3),
                       distributions = distributions, 
                       modelH0 = 'f =~ x1 + x2 + x3')
                       
distributions <- list(
  list('rnorm', list(mean = 0, sd = 10)),
  list('runif', list(min = 0, max = 1)),
  list('rbeta', list(shape1 = 1, shape2 = 2)),
  list('rexp', list(rate = 1)),
  list('rpois', list(lambda = 4)),
  list('rbinom', list(size = 1, prob = .5))
)
data <- genData.ruscio(N = 100, Sigma = diag(6),
                       distributions = distributions, 
                       modelH0 = 'f1=~x1+x2+x3\nf2=~x4+x5+x6')

}
}
