% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mahalanobis_exo.R
\name{mahalanobis_predictors}
\alias{mahalanobis_predictors}
\title{Mahalanobis Distance On Observed Predictors}
\usage{
mahalanobis_predictors(
  fit,
  emNorm_arg = list(estimate.worst = FALSE, criterion = 1e-06)
)
}
\arguments{
\item{fit}{It can be the output from \code{lavaan}, such as
\code{\link[lavaan:cfa]{lavaan::cfa()}} and \code{\link[lavaan:sem]{lavaan::sem()}}, or the output from
\code{\link[=lavaan_rerun]{lavaan_rerun()}}.}

\item{emNorm_arg}{No longer used. Kept for backward
compatibility.}
}
\value{
A \code{md_semfindr}-class object, which is
a one-column matrix (a column vector) of the Mahalanobis
distance for each case. The number of rows equals to the number of
cases in the data stored in the fit object.
A print method is available for user-friendly output.
}
\description{
Gets a \code{\link[=lavaan_rerun]{lavaan_rerun()}} or \code{\link[lavaan:lavaan]{lavaan::lavaan()}} output
and computes the Mahalanobis distance for each case using only the
observed predictors.
}
\details{
For each case, \code{\link[=mahalanobis_predictors]{mahalanobis_predictors()}} computes the
Mahalanobis distance of each case on the observed predictors.

If there are no missing values, \code{\link[stats:mahalanobis]{stats::mahalanobis()}} will be used
to compute the Mahalanobis distance.

If there are missing values on the observed predictors, the means
and variance-covariance matrices will be estimated by maximum
likelihood using \code{\link[lavaan:lavCor]{lavaan::lavCor()}}. The estimates will be passed
to \code{\link[modi:MDmiss]{modi::MDmiss()}} to compute the Mahalanobis distance.

Supports both single-group and multiple-group models.
For multiple-group models, the Mahalanobis distance for
each case is computed using the means and covariance matrix
of the group this case belongs to.
(Support for multiple-group models available in 0.1.4.8 and later version).
}
\examples{
library(lavaan)
dat <- pa_dat
# For illustration, select only the first 50 cases.
dat <- dat[1:50, ]
# The model
mod <-
"
m1 ~ a1 * iv1 +  a2 * iv2
dv ~ b * m1
a1b := a1 * b
a2b := a2 * b
"
# Fit the model
fit <- lavaan::sem(mod, dat)
summary(fit)

md_predictors <- mahalanobis_predictors(fit)
md_predictors

}
\references{
Béguin, C., & Hulliger, B. (2004). Multivariate outlier detection in
incomplete survey data: The epidemic algorithm and transformed rank
correlations. \emph{Journal of the Royal Statistical Society: Series A
(Statistics in Society)}, 167(2), 275-294.

Mahalanobis, P. C. (1936). On the generalized distance in statistics.
\emph{Proceedings of the National Institute of Science of India, 2}, 49-55.

Schafer, J.L. (1997) \emph{Analysis of incomplete multivariate data}.
Chapman & Hall/CRC Press.
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}.
}
