% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_interactions.R
\name{interaction_term}
\alias{interaction_term}
\title{Interaction function}
\usage{
interaction_term(iv, moderator, method, weights)
}
\arguments{
\item{iv}{The independent variable that is subject to moderation.}

\item{moderator}{The moderator variable.}

\item{method}{The method to generate the estimated interaction term with a
default of `two_stage`.}

\item{weights}{The weighting mode for interaction items in a PLS model (only)
  with default of `modeA`.

Interaction Combinations as generated by the \code{\link{interaction}} or
\code{\link{interaction_term}} methods.}
}
\description{
\code{interaction_term} creates interaction measurement items by applying
product indicator, two stage, or orthogonal approaches to creating new
interaction constructs.
}
\details{
This function automatically generates interaction measurement items for a PLS
or a CBSEM model.
}
\examples{
data(mobi)

# seminr syntax for creating measurement model
mobi_mm <- constructs(
  composite("Image",        multi_items("IMAG", 1:5)),
  composite("Expectation",  multi_items("CUEX", 1:3)),
  composite("Value",        multi_items("PERV", 1:2)),
  composite("Satisfaction", multi_items("CUSA", 1:3)),
  interaction_term(iv = "Image", moderator = "Expectation", method = orthogonal),
  interaction_term(iv = "Image", moderator = "Value", method = product_indicator)
)

#  structural model: note that name of the interactions construct should be
#  the names of its two main constructs joined by a '*' in between.
mobi_sm <- relationships(
  paths(to = "Satisfaction",
        from = c("Image", "Expectation", "Value",
                 "Image*Expectation", "Image*Value"))
)

mobi_pls <- estimate_pls(mobi, mobi_mm, mobi_sm)
summary(mobi_pls)

}
