% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semmcci-methods.R
\name{confint.semmccistd}
\alias{confint.semmccistd}
\title{Monte Carlo Confidence Intervals for the Standardized Parameter Estimates}
\usage{
\method{confint}{semmccistd}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{Object of class \code{semmccistd}.}

\item{parm}{a specification of which parameters are to be given confidence intervals,
either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of confidence intervals.
}
\description{
Monte Carlo Confidence Intervals for the Standardized Parameter Estimates
}
\examples{
library(semmcci)
library(lavaan)

# Generate Data ------------------------------------------------------------
n <- 1000
a <- 0.50
b <- 0.50
cp <- 0.25
s2_em <- 1 - a^2
s2_ey <- 1 - cp^2 - a^2 * b^2 - b^2 * s2_em - 2 * cp * a * b
em <- rnorm(n = n, mean = 0, sd = sqrt(s2_em))
ey <- rnorm(n = n, mean = 0, sd = sqrt(s2_ey))
X <- rnorm(n = n)
M <- a * X + em
Y <- cp * X + b * M + ey
df <- data.frame(X, M, Y)

# Fit Model in lavaan ------------------------------------------------------
model <- "
  Y ~ cp * X + b * M
  M ~ a * X
  indirect := a * b
  direct := cp
  total := cp + (a * b)
"
fit <- sem(data = df, model = model, fixed.x = FALSE)

# Monte Carlo --------------------------------------------------------------
unstd <- MC(
  fit,
  R = 100L, # use a large value e.g., 20000L for actual research
  alpha = c(0.001, 0.01, 0.05)
)

# Standardized Monte Carlo -------------------------------------------------
std <- MCStd(unstd)
confint(std)
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{method}
