% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures.R
\name{merge_measures}
\alias{merge_measures}
\title{Merge sentiment measures}
\usage{
merge_measures(ctr)
}
\arguments{
\item{ctr}{output from a \code{\link{ctr_merge}} call.}
}
\value{
A modified \code{sentomeasures} object, with only the sentiment measures required, including updated information
and statistics, but the original sentiment scores \code{data.table} untouched.
}
\description{
Merge (further aggregate) measures by combining across provided lexicons, features, and time weighting schemes
dimensions. The combination occurs by taking the mean of the relevant measures.
}
\examples{
data("usnews", package = "sentometrics")
data("lexicons", package = "sentometrics")
data("valence", package = "sentometrics")

# construct a sentomeasures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 500)
l <- setup_lexicons(lexicons[c("LM_eng", "HENRY_eng")], valence[["valence_eng"]])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "year", lag = 3)
sentomeasures <- sento_measures(corpusSample, l, ctr)

# set up control function and perform the merging
ctrMerge <- ctr_merge(sentomeasures,
                      time = list(W = c("equal_weight", "linear")),
                      features = list(journals = c("wsj", "wapo")),
                      do.keep = TRUE)
sentomeasuresMerged <- merge_measures(ctrMerge)

}
\seealso{
\code{\link{ctr_merge}}
}
\author{
Samuel Borms
}
