% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentocorpus.R
\name{to_sentocorpus}
\alias{to_sentocorpus}
\title{Convert a quanteda corpus object into a sentocorpus object}
\usage{
to_sentocorpus(corpus, dates, do.clean = FALSE)
}
\arguments{
\item{corpus}{a quanteda \code{\link[quanteda]{corpus}} object.}

\item{dates}{a sequence of dates as \code{"yyyy-mm-dd"}, of the same length as the number of documents
in the input \code{corpus}.}

\item{do.clean}{see \code{do.clean} argument from the \code{\link{sento_corpus}} function.}
}
\value{
A \code{sentocorpus} object, as returned by the \code{\link{sento_corpus}} function.
}
\description{
Converts a \pkg{quanteda} \code{\link[quanteda]{corpus}} object into a \code{sentocorpus} object, by
adding user-supplied dates and doing proper rearranging.
}
\examples{
data("usnews", package = "sentometrics")

# reshuffle usnews data.frame
dates <- usnews$date
usnews$id <- usnews$date <- NULL
usnews$wrong <- "notNumeric"
colnames(usnews)[1] <- "myTexts"

# set up quanteda corpus object
corpusQ <- quanteda::corpus(usnews, text_field = "myTexts")

# corpus conversion
corpusS <- to_sentocorpus(corpusQ, dates = dates)

}
\seealso{
\code{\link[quanteda]{corpus}}, \code{\link{sento_corpus}}
}
\author{
Samuel Borms
}
