# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Get the most informative subjects from unlabeled dataset for the
#'   categorical case
#' @description Get the most informative subjects from unlabeled dataset under
#'   the categorical case.
#' @details
#' A_optimal_cat uses the A optimality criterion from the experimental design
#' to choose the most informative subjects under the the categorical case. We
#' have obtained the variance-covariance matrix based on the current labeled
#' samples which indicates how much information there is. Then we should
#' repeatly calculate the information matrix after we choose a sample from the
#' unlabeled dataset. Once we finish the iteration, we pick the sample which
#' has the most information.
#' @param X A matrix containing all the samples except their labels including
#'   the labeled samples and the unlabeled samples.
#' @param beta A matrix contains the estimated coefficient. Note that the beta
#'   is a n * k matrix which n is the number of the explanatory variables and
#'   k+1 is the number of categories
#' @param W A matrix denotes the inverse information matrix of the coefficient
#'   beta.
#' @param unlabeledIDs A numeric vector for the unique identification of the
#'   unlabeled. dataset.
#' @return a index of the most informative subjects from unlabeled dataset for
#'   the categorical case
A_optimal_cat <- function(X, beta, W, unlabeledIDs) {
    .Call('_seqest_A_optimal_cat', PACKAGE = 'seqest', X, beta, W, unlabeledIDs)
}

#' @title Get the most informative subjects from unlabeled dataset for the
#'   ordinal case
#' @description Get the most informative subjects from unlabeled dataset under
#'   the ordinal case
#' @details
#' A_optimal_ord uses the A optimality criterion from the experimental design
#' to choose the most informative subjects under the the ordinal case. We have
#' obtained the variance-covariance matrix based on the current labeled samples
#' which indicates how much information there is. Then we should repeatly
#' calculate the information matrix after we choose a sample from the unlabeled
#' dataset. Once we finish the iteration, we pick the sample which has the most
#' information.
#' @param X A matrix containing all the samples except their labels including
#'   the labeled samples and the unlabeled samples.
#' @param beta A matrix contains the estimated coefficient. Note that the beta
#'   is a n * k matrix which n is the number of the explanatory variables and
#'   k+1 is the number of categories
#' @param W A matrix denotes the inverse information matrix of the coefficient
#'   beta.
#' @param unlabeledIDs A numeric vector for the unique identification of the
#'   unlabeled. dataset.
#' @return a index of the most informative subjects from unlabeled dataset for
#'   the ordinal case
A_optimal_ord <- function(X, beta, W, unlabeledIDs) {
    .Call('_seqest_A_optimal_ord', PACKAGE = 'seqest', X, beta, W, unlabeledIDs)
}

#' @title Get the most informative subjects for the clustered data
#' @description Get the most informative subjects for the highly stratified
#'   response data by the D-optimility.
#' @details
#' D_optimal uses the D-optimality criterion from the experimental design to
#' choose the most informative subjects for the highly stratified response
#' data.
#' @param X A data frame contains all the random samples which we will choose
#'   subject from.
#' @param id  The id for each subject in the X
#' @param beta The paramters that we estimate under the current samples
#' @param nonZeroSet The set of the index of the non zero coefficient
#' @param M A numeric matrix calculated by the \code{\link{getMH}} function
#' @param rho A numeric number indicating the estimate of correlation
#'   coefficient
#' @param linkv A specification for the model link function.
#' @param corstrv A character string specifying the correlation structure. The
#'   following are permitted: "independence", "exchangeable" and "ar1".
#' @return a index of the most informative subject
D_optimal <- function(X, id, beta, nonZeroSet, M, rho, linkv, corstrv) {
    .Call('_seqest_D_optimal', PACKAGE = 'seqest', X, id, beta, nonZeroSet, M, rho, linkv, corstrv)
}

#' @title Calculate quasi-likelihood under the independence model criterion
#'   (QIC) for Generalized Estimating Equations.
#' @description Select the optimal model according to the QIC criterion
#' @details
#' QIC calculates the value of the quasi-likelihood under the independence
#' model criterion for Generalized Estimating Equations. The QIC criterion is
#' actually a generalization of the AIC criterion in the statistical inference
#' of parameters in the longitudinal data analysis framework.
#'
#' @param y A matrix containing current response variable
#' @param X A data frame containing the covariate for the current samples
#' @param id  The id for each subject in the X
#' @param beta The paramters that we estimate when we use the current samples
#' @param nonZeroSet The set of the index of the non zero coefficient
#' @param rho A numeric number indicating the estimate of correlation coefficient
#' @param linkv A specification for the model link function.
#' @param corstrv A character string specifying the correlation structure. The
#'   following are permitted: "independence", "exchangeable" and "ar1".
#' @return a value indicating how well the model fits
QIC <- function(y, X, id, beta, nonZeroSet, rho, linkv, corstrv) {
    .Call('_seqest_QIC', PACKAGE = 'seqest', y, X, id, beta, nonZeroSet, rho, linkv, corstrv)
}

#' @title Get the matrices M and H for the clustered data for the GEE case
#' @description Get the matrices M and H to approximate the true covariance
#'   matrix of the GEE case
#' @details
#' getMH uses the current samples to obtain the covariance matrix.
#' @param y A matrix containing current response variable
#' @param X A data frame containing the covariate for the current samples
#' @param id  The id for each subject in the X
#' @param beta The paramters that we estimate when we use the current samples
#' @param rho A numeric number indicating the estimate of correlation
#'   coefficient
#' @param linkv A specification for the model link function.
#' @param corstrv A character string specifying the correlation structure. The
#'   following are permitted: "independence", "exchangeable" and "ar1".
#' @return a list contains several components
#' \item{sandwich}{the sandwich information matrix for covariance}
#' \item{M}{the matrix for calculating the sandwich information matrix for covariance}
#' \item{H}{the matrix for calculating the sandwich information matrix for covariance}
getMH <- function(y, X, id, beta, rho, linkv, corstrv) {
    .Call('_seqest_getMH', PACKAGE = 'seqest', y, X, id, beta, rho, linkv, corstrv)
}

#' @title Get the matrices W and H for the categorical case
#' @description Get the matrices W and H using the Rcpp package for the
#'   categorical case
#' @details
#' getWH uses the current training data and the estimated coefficient under the
#' categorical case to obtain the matrices W and H to further get the
#' variance-covariance matrix and minimum eigenvalue. The variance-covariance
#' matrix and minimum eigenvalue will be used in the process of selecting the
#' new sampling and determining whether to stop the iteration. Note that using
#' the Rcpp package can significantly reduce the time of operation and get
#' conclusions faster.
#'
#' @param data A matrix containing the training samples which we will use in
#'   the categorical case.
#' @param beta A matrix contains the estimated coefficient. Note that the
#'   beta_mat is a n * k matrix which n is the number of the explanatory
#'   variables and k+1 is the number of categories
#' @return a list contains several components including the variance-covariance
#'   matrix, minimum eigenvalue, W and H.
getWH <- function(data, beta) {
    .Call('_seqest_getWH', PACKAGE = 'seqest', data, beta)
}

#' @title Get the matrices W and H for the ordinal case
#' @description Get the matrices W and H using the Rcpp package for the ordinal case
#' @details
#' getWH_ord uses the current training data and the estimated coefficient under
#' the ordinal case to obtain the matrices W and H to further get the
#' variance-covariance matrix and minimum eigenvalue. Note that using the Rcpp
#' package can significantly reduce the time of operation and get conclusions
#' faster.
#'
#' @param data A matrix containing the training samples which we will use in
#'   the ordinal case.
#' @param beta A matrix contains the estimated coefficient. Note that the
#'   beta_mat is a n * k matrix which n is the number of the explanatory
#'   variables and k+1 is the number of categories
#' @return a list contains several components including the variance-covariance
#'   matrix, minimum eigenvalue, W and H.
#'
#'
getWH_ord <- function(data, beta) {
    .Call('_seqest_getWH_ord', PACKAGE = 'seqest', data, beta)
}

