% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcMaxMismatch.R
\name{CalcMaxMismatch}
\alias{CalcMaxMismatch}
\title{Maximum number of mismatches}
\usage{
CalcMaxMismatch(Err, MAF, ErrFlavour = "version2.0", qntl = 1 - 1e-05)
}
\arguments{
\item{Err}{estimated genotyping error rate, as a single number or 3x3 matrix.
If a matrix, this should be the probability of observed genotype (columns)
conditional on actual genotype (rows). Each row must therefore sum to 1.}

\item{MAF}{vector with minor allele frequency at each SNP.}

\item{ErrFlavour}{function that takes \code{Err} as input, and returns a 3x3
matrix of observed (columns) conditional on actual (rows) genotypes, or
choose from inbuilt ones as used in sequoia 'version2.0', 'version1.3', or
'version1.1'. Ignored if \code{Err} is a matrix. See \code{\link{ErrToM}}.}

\item{qntl}{quantile of binomial distribution to be used as the maximum, of
individual-level probability. For a desired dataset-level probability
quantile \eqn{Q}, use \eqn{qntl = Q^(1/N)}, where \eqn{N} is the number of
individuals.}
}
\value{
a vector with three integers:
 \item{DUP}{Maximum number of differences between 2 samples from the
  same individual}
 \item{OH}{Maximum number of Opposing Homozygous SNPs between a true
   parent-offspring pair}
 \item{ME}{Maximum number of Mendelian Errors among a true parent-parent-
  offspring trio}
}
\description{
Calculate the maximum expected number of mismatches for
  duplicate samples, parent-offspring pairs, and parent-parent-offspring
  trios.
}
\details{
The thresholds for maximum number of mismatches calculated here aim
  to minimise false negatives, i.e. to minimise the chance that any true
  duplicates or true parent-offspring pairs are already excluded during the
  filtering steps where these \code{MaxMismatch} values are used.
  Consequently, there is a high probability of false positives, i.e. it is
  likely that some sample pairs with fewer mismatches than the
  \code{MaxMismatch} threshold, are in fact not duplicate samples or
  parent-offspring pairs. Use of these \code{MaxMismatch} thresholds is
  therefore only the first step of pedigree reconstruction by
  \code{\link{sequoia}}.
}
\seealso{
\code{\link{SnpStats}}
}
