% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchical_bayesian_model.R
\name{hierarchical_bayesian_model}
\alias{hierarchical_bayesian_model}
\title{Hierarchical Bayesian Model}
\usage{
hierarchical_bayesian_model(
  age,
  pos = NULL,
  tot = NULL,
  status = NULL,
  type = "far3",
  chains = 1,
  warmup = 1500,
  iter = 5000
)
}
\arguments{
\item{age}{the age vector}

\item{pos}{the positive count vector (optional if status is provided).}

\item{tot}{the total count vector (optional if status is provided).}

\item{status}{the serostatus vector (optional if pos & tot are provided).}

\item{type}{type of model ("far2", "far3" or "log_logistic")}

\item{chains}{number of Markov chains}

\item{warmup}{number of warmup runs}

\item{iter}{number of iterations}
}
\value{
a list of class hierarchical_bayesian_model with 6 items
  \item{datatype}{type of datatype used for model fitting (aggregated or linelisting)}
  \item{df}{the dataframe used for fitting the model}
  \item{type}{type of bayesian model far2, far3 or log_logistic}
  \item{info}{parameters for the fitted model}
  \item{sp}{seroprevalence}
  \item{foi}{force of infection}
}
\description{
Refers to section 10.3
}
\examples{
\donttest{
df <- mumps_uk_1986_1987
model <- hierarchical_bayesian_model(age = df$age, pos = df$pos, tot = df$tot, type="far3")
model$info
plot(model)
}
}
