% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{parvob19_be_2001_2003}
\alias{parvob19_be_2001_2003}
\title{Parvo B19 serological data from Belgium from 2001-2003 (line listing)}
\format{
A data frame with 5 variables:
\describe{
 \item{age}{Age of individual}
 \item{seropositive}{If the individual is seropositive or not}
 \item{year}{Year surveyed}
 \item{gender}{Gender of individual}
 \item{parvouml}{Parvo B19 antibody units per ml}
}
}
\source{
MOSSONG, J., N. HENS, V. FRIEDERICHS, I. DAVIDKIN, M. BROMAN,
B. LITWINSKA, J. SIENNICKA, et al. "Parvovirus B19 Infection in Five
European Countries: Seroepidemiology, Force of Infection and Maternal Risk
of Infection." Epidemiology and Infection 136, no. 8 (2008): 1059-68.
\doi{doi:10.1017/S0950268807009661}
}
\usage{
parvob19_be_2001_2003
}
\description{
A seroprevalence survey testing for parvovirus B19 IgG antibody, performed on
large representative national serum banks in Belgium, England and Wales,
Finland, Italy, and Poland. The sera were collected between 1995 and 2004 and
were obtained from residual sera submitted for routine laboratory testing.
}
\examples{
# Reproduce Fig 4.5 (left upper panel), p. 68
library(dplyr)
df <- parvob19_be_2001_2003 \%>\%
  group_by(age) \%>\%
  summarise(pos = sum(seropositive), tot = n())
plot(df$age, df$pos / df$tot,
  cex = 0.02 * df$tot, pch = 16, xlab = "age", ylab = "seroprevalence",
  xlim = c(0, 82), ylim = c(0, 1)
)

}
\keyword{datasets}
