% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testFuzzySet}
\alias{testFuzzySet}
\alias{checkFuzzySet}
\alias{assertFuzzySet}
\title{assert/check/test/FuzzySet}
\usage{
testFuzzySet(object, errormsg = "This is not an R6 FuzzySet object")

checkFuzzySet(object, errormsg = "This is not an R6 FuzzySet object")

assertFuzzySet(object, errormsg = "This is not an R6 FuzzySet object")
}
\arguments{
\item{object}{object to test}

\item{errormsg}{error message to overwrite default if check fails}
}
\value{
If check passes then \code{assert} returns \code{object} invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, and \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if a given object is an R6 \code{FuzzySet}.
}
\examples{
testFuzzySet(Set$new(2, 3))
testFuzzySet(list(Set$new(2), Set$new(3)))
testFuzzySet(Tuple$new(2, 3))
testFuzzySet(Interval$new())
testFuzzySet(FuzzySet$new(2, 0.1))
testFuzzySet(FuzzyTuple$new(2, 0.1))
testFuzzySet(ConditionalSet$new(function(x) x == 0))
}
