% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testContains}
\alias{testContains}
\alias{checkContains}
\alias{assertContains}
\title{assert/check/test/Contains}
\usage{
testContains(
  object,
  elements,
  errormsg = "elements are not contained in the set"
)

checkContains(
  object,
  elements,
  errormsg = "elements are not contained in the set"
)

assertContains(
  object,
  elements,
  errormsg = "elements are not contained in the set"
)
}
\arguments{
\item{object}{object to test}

\item{elements}{elements to check}

\item{errormsg}{error message to overwrite default if check fails}
}
\value{
If check passes then \code{assert} returns \code{object} invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, and \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if given elements are contained in a set.
}
\examples{
testContains(Set$new(1,2,3), c(1,2))
testContains(Set$new(1,2,3), c(3,4))
}
