% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsgpv.R
\name{plotsgpv}
\alias{plotsgpv}
\title{Second-Generation p-Value Plotting}
\usage{
plotsgpv(
  est.lo,
  est.hi,
  null.lo,
  null.hi,
  set.order = "sgpv",
  x.show = NA,
  null.col = rgb(208, 216, 232, maxColorValue = 255),
  int.col = c("cornflowerblue", "firebrick3", "darkslateblue"),
  int.pch = NA,
  int.cex = 0.4,
  plot.axis = c(TRUE, TRUE),
  null.pt = NA,
  outline.zone = TRUE,
  title.lab = "Title",
  x.lab = "Position (by set.order)",
  y.lab = "Outcome label",
  legend.on = TRUE
)
}
\arguments{
\item{est.lo}{A numeric vector of lower bounds of interval estimates. Values must be finite for interval to be drawn. Must be of same length as \code{est.hi}.}

\item{est.hi}{A numeric vector of upper bounds of interval estimates. Values must be finite for interval to be drawn. Must be of same length as \code{est.lo}.}

\item{null.lo}{A scalar representing the lower bound of null interval (indifference zone). Value must be finite.}

\item{null.hi}{A scalar representing the upper bound of null interval (indifference zone). Value must be finite.}

\item{set.order}{A numeric vector giving the desired order along the x-axis. If \code{set.order} is set to \code{sgpv}, the second-generation \emph{p}-value ranking is used. If \code{set.order} is set to \code{NA}, the original input ordering is used.}

\item{x.show}{A scalar representing the maximum ranking on the x-axis that is displayed. Default is to display all intervals.}

\item{null.col}{Coloring of the null interval (indifference zone). Default is Hawkes Blue: \code{rgb(208,216,232,maxColorValue=255)}.}

\item{int.col}{Coloring of the intervals according to SGPV ranking. Default is \code{c("cornflowerblue","firebrick3","darkslateblue")} for SGPVs of \eqn{0}, in \eqn{(0,1)}, and \eqn{1} respectively.}

\item{int.pch}{Plotting symbol for interval endpoints. Default is \code{NA}, no symbol. Use \code{16} for small endpoints.}

\item{int.cex}{Size of plotting symbol for interval endpoints. Default is \eqn{0.4}.}

\item{plot.axis}{Toggle for default axis plotting. Default is \code{c(TRUE,TRUE)} for \eqn{(x-axis,y-axis)} respectively.}

\item{null.pt}{A scalar representing a point null hypothesis. Default is \code{NA}. If set, the function will draw a horizontal dashed black line at this location.}

\item{outline.zone}{Toggle for drawing a slim white outline around the null zone. Helpful visual aid when plotting many intervals. Default is \code{TRUE}.}

\item{title.lab}{Title text.}

\item{x.lab}{x-axis label.}

\item{y.lab}{y-axis label.}

\item{legend.on}{Toggle for plotting the legend. Default is \code{TRUE}.}
}
\description{
This function displays user supplied interval estimates (support intervals, confidence intervals, credible intervals, etc.) according to its associated second-generation \emph{p}-value ranking.
}
\details{
Use \code{set.order} to provide the classical p-value ranking. For example, if \code{pvalue.vector} is a vector of classical p-values, then set \code{set.order=order(pvalue.vector)} to sort the x-axis according to p-value rank.

Interval estimates with infinite or undefined limits should be manually truncated or avoided altogether. While the sgpvalue funciton will handle these cases, this function assumes they have been truncated or removed because there is no standard way to plot them.
}
\examples{

# Use leukstats data
data(leukstats)
plotsgpv(est.lo=leukstats$ci.lo, est.hi=leukstats$ci.hi,
		null.lo=-0.3, null.hi=0.3,
		set.order=order(leukstats$p.value),
		x.show=7000,
		plot.axis=c("TRUE","FALSE"),
		null.pt=0, outline.zone=TRUE,
		title.lab="Leukemia Example", y.lab="Fold Change (base 10)",
		x.lab="Classical p-value ranking",
		legend.on=TRUE)
axis(side=2,at=round(log(c(1/1000,1/100,1/10,1/2,1,2,10,100,1000),
	base=10),2),labels=c("1/1000","1/100","1/10","1/2",1,2,10,100,1000),
	las=2)


}
\references{
Blume JD, Greevy RA Jr., Welty VF, Smith JR, Dupont WD (2019). An Introduction to Second-generation \emph{p}-values. \emph{The American Statistician}. 73:sup1, 157-167, DOI: https://doi.org/10.1080/00031305.2018.1537893

Blume JD, D’Agostino McGowan L, Dupont WD, Greevy RA Jr. (2018). Second-generation \emph{p}-values: Improved rigor, reproducibility, & transparency in statistical analyses. \emph{PLoS ONE} 13(3): e0188299. https://doi.org/10.1371/journal.pone.0188299
}
\seealso{
\code{\link{sgpvalue}, \link{sgpower}, \link{fdrisk}}
}
