% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inShadow.R
\docType{methods}
\name{inShadow}
\alias{inShadow}
\alias{inShadow,SpatialPoints,Raster,missing,missing,missing-method}
\alias{inShadow,SpatialPoints,missing,SpatialPolygonsDataFrame,character,matrix-method}
\title{Logical shadow calculation (is given point shaded?) for 3D points considering sun position and obstacles}
\usage{
\S4method{inShadow}{SpatialPoints,Raster,missing,missing,missing}(location,
  shadowHeightRaster, obstacles, obstacles_height_field, solar_pos)


  \S4method{inShadow}{SpatialPoints,missing,SpatialPolygonsDataFrame,character,matrix}(location,
  shadowHeightRaster, obstacles, obstacles_height_field, solar_pos, ...)
}
\arguments{
\item{location}{A \code{SpatialPoints*} or \code{Raster*} object, specifying the location(s) for which to calculate shadow height}

\item{shadowHeightRaster}{Raster representing shadow height}

\item{obstacles}{A \code{SpatialPolygonsDataFrame} object specifying the obstacles outline}

\item{obstacles_height_field}{Name of attribute in \code{obstacles} with extrusion height for each feature}

\item{solar_pos}{A matrix with two columns representing sun position(s); first column is the solar azimuth (in degrees from North), second column is sun elevation (in degrees); rows represent different positions (e.g. at different times of day)}

\item{...}{Other parameters passed to \code{shadowHeight}}
}
\value{
Logical \code{matrix} with rows representing spatial locations (\code{location} features) and columns representing solar positions (\code{solar_pos} rows)
}
\description{
This function determines whether each given point in a set of 3D points (\code{location}), is shaded or not
taking into account:\itemize{
\item{Obstacles outline (\code{obstacles}), given by a polygonal layer with a height attribute (\code{obstacles_height_field})}
\item{Sun position (\code{solar_pos}), given by azimuth and elevation angles}
}
}
\note{
For a correct geometric calculation, make sure that:\itemize{
\item{The layers \code{location} and \code{obstacles} are projected and in same CRS}
\item{The values in \code{obstacles_height_field} of \code{obstacles} are given in the same distance units as the CRS (e.g. meters when using UTM)}
}
}
\examples{

\dontrun{
# Method for obstacles and sun position
obstacles = rishon[c(2, 4), ]
location = surfaceGrid(
  obstacles = obstacles,
  obstacles_height_field = "BLDG_HT",
  res = 2,
  offset = 0.01
)
solar_pos = matrix(c(88.83113, 46.724), ncol = 2)
s = inShadow(
  location = location,
  obstacles = obstacles,
  obstacles_height_field = "BLDG_HT",
  solar_pos = solar_pos
)
location$shadow = s[, 1]
plotGrid(location, color = c("yellow", "grey")[as.factor(location$shadow)], size = 0.5)
}

# Method for pre-calculated shadow height raster
ext = as(raster::extent(rishon), "SpatialPolygons")
r = raster::raster(ext, res = 1)
proj4string(r) = proj4string(rishon)
r[] = rep(seq(30, 0, length.out = ncol(r)), times = nrow(r))
location = surfaceGrid(
  obstacles = rishon[c(2, 4), ],
  obstacles_height_field = "BLDG_HT",
  res = 2,
  offset = 0.01
)
s = inShadow(
  location = location,
  shadowHeightRaster = r
)
location$shadow = s[, 1]
r_pnt = raster::as.data.frame(r, xy = TRUE)
coordinates(r_pnt) = names(r_pnt)
proj4string(r_pnt) = proj4string(r)
r_pnt = SpatialPointsDataFrame(
  r_pnt,
  data.frame(
    shadow = rep(TRUE, length(r_pnt)),
    stringsAsFactors = FALSE
    )
 )
pnt = rbind(location[, "shadow"], r_pnt)
\dontrun{
plotGrid(pnt, color = c("yellow", "grey")[as.factor(pnt$shadow)], size = 0.5)
}

}
