% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapeR.R
\name{plotWaveletShape}
\alias{plotWaveletShape}
\title{Mean otolith shape based on wavelet reconstruction}
\usage{
plotWaveletShape(object, class.name,show.angle=FALSE,lty=1:5,col=1:6,...)
}
\arguments{
\item{object}{A \code{\linkS4class{shapeR}} object}

\item{class.name}{A string as the column name in the master list}

\item{show.angle}{If TRUE angles are shown on the plot}

\item{lty, col}{Vector of line types and colors. Values are used cyclically.}

\item{...}{Additional parameters to be passed to 'plot'}
}
\value{
None
}
\description{
A function for showing the mean otolith shape based on wavelet reconstruction
}
\examples{
data(shape)
plotWaveletShape(shape, "pop",show.angle = TRUE,lwd=2,lty=1)
}
\references{
Nason, G. (2012) \code{\link{wavethresh}}: Wavelets statistics and transforms, version 4.5. R package.
}
\author{
Lisa Anne Libungan
}
