% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_randomized_pattern.R
\name{plot_randomized_pattern}
\alias{plot_randomized_pattern}
\title{plot_randomized_pattern}
\usage{
plot_randomized_pattern(pattern, method = "spatial", probs = c(0.025,
  0.975), comp_fast = FALSE)
}
\arguments{
\item{pattern}{List with reconstructed patterns.}

\item{method}{String to specifiy if spatial pattern or marks were reconstructed}

\item{probs}{Quantiles of randomized data used for envelope construction.}

\item{comp_fast}{Should summary functions be estimated in an computational fast way.}
}
\value{
ggplot
}
\description{
Plot randomized pattern
}
\details{
The function plots the pair correlation function and the nearest neighbour function
the observed pattern and the reconstructed patterns (as "simulation envelopes".).
For large patterns `comp_fast = TRUE` decreases the computational demand because no edge
correction is used and the pair correlation function is estimated based on Ripley's
K-function. For more information see \code{\link{estimate_pcf_fast}}.
}
\examples{
pattern_random <- fit_point_process(species_a, n_random = 19, process = "cluster")
plot_randomized_pattern(pattern_random)

\dontrun{
marks_sub <- spatstat::subset.ppp(species_a, select = dbh)
marks_recon <- reconstruct_marks(pattern_random[[1]], marks_sub, n_random = 19, max_runs = 1000)
plot_randomized_pattern(marks_recon, method = "marks")
}

}
