% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results_habitat_association.R
\name{results_habitat_association}
\alias{results_habitat_association}
\title{results_habitat_association}
\usage{
results_habitat_association(
  pattern,
  raster,
  significance_level = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{pattern}{ppp object with original point pattern data or rd_pat or rd_mar
object with randomized point pattern.}

\item{raster}{RasterLayer with original discrete habitat data or rd_ras object with
randomized environmental data.}

\item{significance_level}{Double with significance level.}

\item{verbose}{Logical if messages should be printed.}
}
\value{
data.frame
}
\description{
Results habitat association
}
\details{
The functions shows significant habitat associations by comparing the number of
points within a habitat between the observed data and randomized data as described in
Plotkin et al. (2000) and Harms et al. (2001). Significant positive or associations are present
if the observed count in a habitat is above or below a certain threshold of the
randomized count, respectively.

In case the RasterLayer contains NA cells, this needs to be reflected in the observation
window of the point pattern as well (i.e., no point locations possible in these areas).
}
\examples{
landscape_classified <- classify_habitats(landscape, classes = 5)
species_a_random <- fit_point_process(species_a, n_random = 199)
results_habitat_association(pattern = species_a_random, raster = landscape_classified)

}
\references{
Harms, K. E., Condit, R., Hubbell, S. P., & Foster, R. B. (2001). Habitat associations
of trees and shrubs in a 50-ha neotropical forest plot. Journal of Ecology, 89(6), 947-959.

Plotkin, J. B., Potts, M. D., Leslie, N., Manokaran, N., LaFrankie, J. V., & Ashton, P. S. (2000).
Species-area curves, spatial aggregation, and habitat specialization in tropical forests.
Journal of Theoretical Biology, 207(1), 81-99.
}
\seealso{
\code{\link{reconstruct_pattern}} \cr
\code{\link{fit_point_process}}
}
