% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\name{createMutabilityMatrix}
\alias{createMutabilityMatrix}
\title{Builds a mutability model}
\usage{
createMutabilityMatrix(db, substitutionModel, model = c("S", "RS"),
  sequenceColumn = "SEQUENCE_IMGT", germlineColumn = "GERMLINE_IMGT_D_MASK",
  vCallColumn = "V_CALL", multipleMutation = c("independent", "ignore"),
  minNumSeqMutations = 500, numSeqMutationsOnly = FALSE,
  returnSource = FALSE)
}
\arguments{
\item{db}{data.frame containing sequence data.}

\item{substitutionModel}{matrix of 5-mer substitution rates built by 
\link{createSubstitutionMatrix}. Note, this model will
only impact mutability scores when \code{model="S"}
(using only silent mutations).}

\item{model}{type of model to create. The default model, "S", 
builds a model by counting only silent mutations. \code{model="S"}
should be used for data that includes functional sequences.
Setting \code{model="RS"} creates a model by counting both 
replacement and silent mutations and may be used on fully 
non-functional sequence data sets.}

\item{sequenceColumn}{name of the column containing IMGT-gapped sample sequences.}

\item{germlineColumn}{name of the column containing IMGT-gapped germline sequences.}

\item{vCallColumn}{name of the column containing the V-segment allele call.}

\item{multipleMutation}{string specifying how to handle multiple mutations occuring 
within the same 5-mer. If \code{"independent"} then multiple 
mutations within the same 5-mer are counted indepedently. 
If \code{"ignore"} then 5-mers with multiple mutations are 
excluded from the total mutation tally.}

\item{minNumSeqMutations}{minimum number of mutations in sequences containing each 5-mer
to compute the mutability rates. If the number is smaller 
than this threshold, the mutability for the 5-mer will be 
inferred. Default is 500. Not required if 
\code{numSeqMutationsOnly=TRUE}.}

\item{numSeqMutationsOnly}{when \code{TRUE}, return only a vector counting the number of 
observed mutations in sequences containing each 5-mer. This 
option can be used for parameter tuning for \code{minNumSeqMutations} 
during preliminary analysis using \link{minNumSeqMutationsTune}. 
Default is \code{FALSE}.}

\item{returnSource}{return the sources of 5-mer mutabilities (measured vs.
inferred). Default is \code{FALSE}.}
}
\value{
When \code{numSeqMutationsOnly} is \code{FALSE}, a named numeric vector of 1024 
          normalized mutability rates for each 5-mer motif with names defining the 5-mer 
          nucleotide sequence. 
          
          When \code{numSeqMutationsOnly} is \code{TRUE}, a named numeric
          vector of length 1024 counting the number of observed mutations in sequences containing 
          each 5-mer.
}
\description{
\code{createMutabilityMatrix} builds a 5-mer nucleotide mutability model by counting 
the number of mutations occuring in the center position for all 5-mer motifs.
}
\details{
\strong{Caution: The targeting model functions do NOT support ambiguous 
          characters in their inputs. You MUST make sure that your input and germline
          sequences do NOT contain ambiguous characters (especially if they are 
          clonal consensuses returned from \code{collapseClones}).}
}
\examples{
\donttest{
# Subset example data to one isotype and sample as a demo
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, ISOTYPE == "IgA" & SAMPLE == "-1h")

# Create model using only silent mutations
sub_model <- createSubstitutionMatrix(db, model="S")
mut_model <- createMutabilityMatrix(db, sub_model, model="S", 
                                    minNumSeqMutations=200,
                                    numSeqMutationsOnly=FALSE)

# Count the number of mutations in sequences containing each 5-mer
mut_count <- createMutabilityMatrix(db, sub_model, model="S", 
                                   numSeqMutationsOnly=TRUE)
}

}
\references{
\enumerate{
  \item  Yaari G, et al. Models of somatic hypermutation targeting and substitution based
           on synonymous mutations from high-throughput immunoglobulin sequencing data. 
           Front Immunol. 2013 4(November):358.
 }
}
\seealso{
\link{extendMutabilityMatrix}, \link{createSubstitutionMatrix}, 
          \link{createTargetingMatrix}, \link{createTargetingModel},
          \link{minNumSeqMutationsTune}
}
