% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downsampler.R
\docType{class}
\name{downsampler}
\alias{downsampler}
\title{R6 class for down-sampling data}
\format{
An \code{R6::R6Class} object
}
\description{
A class for down-sampling the data.
See the super class (\code{plotly_datahandler}) to find more members.
Two options to make a \code{shiny} app: use \code{shiny_hugeplot} and
make it by yourself.
See the example.
}
\examples{
\donttest{
data(noise_fluct)

# example 1: where shiny_hugeplot is employed
# It is very easy
# but customize is difficult and the computation cost might be high
shiny_hugeplot(noise_fluct$t, noise_fluct$level)

# example 2: where user-defined shiny app is employed
# a little complex
# but any layout can be defined and the user can select the method
# where the computation cost is lowest.

fig <- plot_ly(
  x = noise_fluct$t,
  y = noise_fluct$level,
  type = "scatter",
  mode = "lines"
  ) \%>\%
  layout(xaxis = list(type = "date")) \%>\%
  shinyHugePlot::plotly_build_light()

ds <- downsampler$new(figure = fig)

ui <- fluidPage(
  plotlyOutput(outputId = "hp", width = "800px", height = "600px")
)

server <- function(input, output, session) {

  output$hp <- renderPlotly(ds$figure)

  observeEvent(plotly::event_data("plotly_relayout"),{
    updatePlotlyH(session, "hp", plotly::event_data("plotly_relayout"), ds)
  })

}

shinyApp(ui = ui, server = server)

}
}
\section{Super class}{
\code{\link[shinyHugePlot:plotly_datahandler]{shinyHugePlot::plotly_datahandler}} -> \code{downsampler}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{downsample_options}}{Options for down-sampling the data
set in this instance.}

\item{\code{n_out_default}}{Default sample size set in this instance.}

\item{\code{aggregator_default}}{Default aggregator set in this instance.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-downsampler-new}{\code{downsampler$new()}}
\item \href{#method-downsampler-update_trace}{\code{downsampler$update_trace()}}
\item \href{#method-downsampler-set_downsample_options}{\code{downsampler$set_downsample_options()}}
\item \href{#method-downsampler-clone}{\code{downsampler$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="plotly_datahandler" data-id="plotly_data_to_df"><a href='../../shinyHugePlot/html/plotly_datahandler.html#method-plotly_datahandler-plotly_data_to_df'><code>shinyHugePlot::plotly_datahandler$plotly_data_to_df()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="plotly_datahandler" data-id="set_trace_data"><a href='../../shinyHugePlot/html/plotly_datahandler.html#method-plotly_datahandler-set_trace_data'><code>shinyHugePlot::plotly_datahandler$set_trace_data()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-downsampler-new"></a>}}
\if{latex}{\out{\hypertarget{method-downsampler-new}{}}}
\subsection{Method \code{new()}}{
Constructing an abstract down-sampler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{downsampler$new(
  figure = plotly::plot_ly(),
  n_out = 1000L,
  aggregator = min_max_aggregator$new(),
  tz = Sys.timezone(),
  legend_options = list(name_prefix = "<b style=\\"color:sandybrown\\">[R]</b> ",
    name_suffix = "", xdiff_prefix = "<i style=\\"color:#fc9944\\"> ~", xdiff_suffix =
    "</i>")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{figure, legend_options, tz}}{Arguments passed to \code{plotly_datahandler$new}.}

\item{\code{n_out}}{Integer or numeric.
The number of samples shown after down-sampling. By default 1000.}

\item{\code{aggregator}}{An instance of an R6 class for aggregation.
Select an aggregation function. The list of the functions are obtained
using \code{list_aggregators}.
By default, \code{min_max_aggregator$new()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-downsampler-update_trace"></a>}}
\if{latex}{\out{\hypertarget{method-downsampler-update_trace}{}}}
\subsection{Method \code{update_trace()}}{
Update traces (\code{self$figure$x$data}) according to
the relayout order (\code{relayout_order}).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{downsampler$update_trace(
  relayout_order = list(NULL),
  reset = FALSE,
  reload = FALSE,
  send_trace = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{relayout_order}}{Named list.
The list generated by \code{plotlyjs_relayout},
which is obtained using \code{plotly::event_data}.
e.g.,
If you would like set the range of the 2nd x axis to [10.0, 21.5],
\code{list(xaxis2.range[0] = 10.0, xaxis2.range[1] = 21.5)}.
If you would like reset the range of the 1st x axis,
\code{list(xaxis.autorange = TRUE, xaxis.showspike = TRUE)}.}

\item{\code{reset}}{Boolean.
If it is \code{TRUE}, all other arguments are neglected and
the figure will be reset (all the ranges of x axes are initialized).
By default, \code{FALSE}.}

\item{\code{reload}}{Boolean.
If it is \code{TRUE}, the ranges of the figure are preserved but
the aggregation will be conducted with the current settings.
By default, \code{FALSE}.}

\item{\code{send_trace}}{Boolean.
If it is \code{TRUE}, a named list will be returned,
which contains the indexes of the traces that will be updated
(\code{trace_idx_update}) and the updated traces (\code{new_trace}).
By default, \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-downsampler-set_downsample_options"></a>}}
\if{latex}{\out{\hypertarget{method-downsampler-set_downsample_options}{}}}
\subsection{Method \code{set_downsample_options()}}{
Set the options for aggregating the traces.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{downsampler$set_downsample_options(uid = NULL, n_out = NULL, aggregator = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uid}}{Character, optional.
The unique id of the trace.
If \code{NULL}, all the ids registered in this instance is used.
By default, \code{NULL}.}

\item{\code{n_out}}{Numeric or integer, optional.
The number of samples output by the aggregator.
If \code{NULL}, the default value registered in this instance is used.
By default, \code{NULL}.}

\item{\code{aggregator}}{\code{aggregator} object, optional.
An instance that aggregate the data.
If \code{NULL}, the default value registered in this instance is used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-downsampler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-downsampler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{downsampler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
