% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updatePlotlyH.R
\name{updatePlotlyH}
\alias{updatePlotlyH}
\title{Function to call a method to update \code{plotly} traces}
\usage{
updatePlotlyH(
  session,
  outputId,
  relayout_order,
  ds_obj,
  reset = FALSE,
  reload = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{session}{\code{session} object.
The object passed to function given to \code{shinyServer}.}

\item{outputId}{Character.
The \code{outputId} of the figure, whose data will be down-sampled}

\item{relayout_order}{Named list.
The list generated by \code{plotlyjs_relayout},
which is obtained using \code{plotly::event_data}.}

\item{ds_obj}{\code{downsampler} instance.
The instance containing original data of the figure,
which is also used for updating the traces of \code{plotly}.}

\item{reset}{Boolean.
It it is \code{TRUE}, the figure will be updated even if
\code{relayout_order} is \code{NULL}.
The ranges of x axes are reset (initialized).}

\item{reload}{Boolean.
It it is \code{TRUE}, the figure will be updated even if
\code{relayout_order} is \code{NULL}.
The ranges of x axes are preserved.}

\item{verbose}{Boolean.
Whether detailed messages to check the procedures are shown. By default, \code{FALSE}.}
}
\description{
It is used by registering in a \code{shiny} application.
It receives events in \code{plotly} figure and update it using a method of
a \code{downsampler} instance.
See the examples in \code{downsampler} class.
}
