% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-update-inputs.R
\name{updateF7Fab}
\alias{updateF7Fab}
\title{Change the value of a \link{f7Fab} input on the client}
\usage{
updateF7Fab(session, inputId, label = NULL)
}
\arguments{
\item{session}{The session object passed to function given to the server.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}
}
\description{
Change the value of a \link{f7Fab} input on the client
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 ui <- f7Page(
   f7SingleLayout(
    navbar = f7Navbar(title = "updateF7Fab"),
    f7Fab("trigger", "Click me")
   )
 )

 server <- function(input, output, session) {
   observeEvent(input$trigger, {
     updateF7Fab(session, "trigger", label = "Don't click me")
   })
 }
shinyApp(ui, server)
}
}
