% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-update-inputs.R
\name{updateF7Text}
\alias{updateF7Text}
\alias{updateF7TextArea}
\title{Change the value of a text input on the client}
\usage{
updateF7Text(
  inputId,
  label = NULL,
  value = NULL,
  placeholder = NULL,
  session = shiny::getDefaultReactiveDomain()
)

updateF7TextArea(
  inputId,
  label = NULL,
  value = NULL,
  placeholder = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{The value to set for the input object.}

\item{placeholder}{The placeholder to set for the input object.}

\item{session}{The Shiny session object, usually the default value will suffice.}
}
\description{
Change the value of a text input on the client
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 ui <- f7Page(
   f7SingleLayout(
    navbar = f7Navbar(title = "updateF7Text"),
    f7Block(f7Button("trigger", "Click me")),
    f7Text(
     inputId = "text",
     label = "Caption",
     value = "Some text",
     placeholder = "Your text here"
    ),
    verbatimTextOutput("value")
   )
 )

 server <- function(input, output, session) {
   output$value <- renderPrint(input$text)
   observeEvent(input$trigger, {
     updateF7Text("text", value = "Updated Text")
   })
 }
shinyApp(ui, server)
}
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 ui <- f7Page(
   f7SingleLayout(
    navbar = f7Navbar(title = "updateF7TextArea"),
    f7Block(f7Button("trigger", "Click me")),
    f7TextArea(
     inputId = "textarea",
     label = "Text Area",
     value = "Lorem ipsum dolor sit amet, consectetur
              adipiscing elit, sed do eiusmod tempor incididunt ut
              labore et dolore magna aliqua",
     placeholder = "Your text here",
     resize = TRUE
     ),
    verbatimTextOutput("value")
   )
 )

 server <- function(input, output, session) {
   output$value <- renderPrint(input$textarea)
   observeEvent(input$trigger, {
     updateF7Text("textarea", value = "Updated Text")
   })
 }
shinyApp(ui, server)
}
}
