% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-tabs.R
\name{f7InsertTab}
\alias{f7InsertTab}
\alias{insertF7Tab}
\title{Framework7 tab insertion}
\usage{
f7InsertTab(
  id,
  tab,
  target,
  position = c("before", "after"),
  select = FALSE,
  session = shiny::getDefaultReactiveDomain()
)

insertF7Tab(
  id,
  tab,
  target,
  position = c("before", "after"),
  select = FALSE,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{id}{\link{f7Tabs} id.}

\item{tab}{\link{f7Tab} to insert.}

\item{target}{\link{f7Tab} after of before which the new tab will be inserted.}

\item{position}{Insert before or after: \code{c("before", "after")}.}

\item{select}{Whether to select the newly inserted tab. FALSE by default.}

\item{session}{Shiny session object.}
}
\description{
\link{f7InsertTab} is deprecated. Inserts a \link{f7Tab} in a \link{f7Tabs}.

\link{insertF7Tab} inserts a \link{f7Tab} in a \link{f7Tabs}.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shinyApp(
   ui = f7Page(
     title = "Insert a tab Before the target",
     f7TabLayout(
       panels = tagList(
         f7Panel(title = "Left Panel", side = "left", theme = "light", "Blabla", effect = "cover"),
         f7Panel(title = "Right Panel", side = "right", theme = "dark", "Blabla", effect = "cover")
       ),
       navbar = f7Navbar(
         title = "Tabs",
         hairline = FALSE,
         shadow = TRUE,
         leftPanel = TRUE,
         rightPanel = TRUE
       ),
       f7Tabs(
         animated = TRUE,
         id = "tabs",
         f7Tab(
           tabName = "Tab 1",
           icon = f7Icon("email"),
           active = TRUE,
           "Tab 1",
           f7Button(inputId = "go", label = "Go")
         ),
         f7Tab(
           tabName = "Tab 2",
           icon = f7Icon("today"),
           active = FALSE,
           "Tab 2"
         )
       )
     )
   ),
   server = function(input, output, session) {
     observeEvent(input$go, {
       f7InsertTab(
         id = "tabs",
         position = "before",
         target = "Tab 2",
         tab = f7Tab (tabName = paste0("tab_", input$go), "Test"),
         select = TRUE
       )
     })
   }
 )
}

}
