% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Popup.R
\name{f7Popup}
\alias{f7Popup}
\alias{f7TogglePopup}
\alias{updateF7Popup}
\title{Framework7 popup}
\usage{
f7Popup(
  ...,
  id,
  title = NULL,
  backdrop = TRUE,
  closeByBackdropClick = TRUE,
  closeOnEscape = FALSE,
  animate = TRUE,
  swipeToClose = FALSE,
  fullsize = FALSE,
  closeButton = TRUE
)

f7TogglePopup(id, session = shiny::getDefaultReactiveDomain())

updateF7Popup(id, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{...}{UI elements for the body of the popup window.}

\item{id}{Popup id.}

\item{title}{Title for the popup window, use \code{NULL} for no title.}

\item{backdrop}{Enables Popup backdrop (dark semi transparent layer behind).
Default to \code{TRUE}.}

\item{closeByBackdropClick}{When enabled, popup will be closed on backdrop click.
Default to \code{TRUE}.}

\item{closeOnEscape}{When enabled, popup will be closed on ESC keyboard key press.
Default to \code{FALSE}.}

\item{animate}{Whether the Popup should be opened/closed with animation or not.
Default to \code{TRUE}.}

\item{swipeToClose}{Whether the Popup can be closed with swipe gesture.
Can be true to allow to close popup with swipes to top and to bottom.
Default to \code{FALSE}.}

\item{fullsize}{Open popup in full width or not. Default to \code{FALSE}.}

\item{closeButton}{Add or not a button to easily close the popup.
Default to \code{TRUE}.}

\item{session}{Shiny session.}
}
\description{
\link{f7Popup} creates a popup window with any UI content that pops up over App's main content.
Popup as all other overlays is part of so called "Temporary Views".

Deprecated. \link{f7TogglePopup} toggles a \link{f7Popup} from the server.

\link{updateF7Popup} toggles a \link{f7Popup} from the server.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shinyApp(
   ui = f7Page(
     title = "Popup",
     f7SingleLayout(
      navbar = f7Navbar(
        title = "f7Popup",
        hairline = FALSE,
        shadow = TRUE
      ),
      f7Button("togglePopup", "Toggle Popup"),
      f7Popup(
       id = "popup1",
       title = "My first popup",
       f7Text("text", "Popup content", "This is my first popup ever, I swear!"),
       verbatimTextOutput("popupContent")
      )
     )
   ),
   server = function(input, output, session) {

    output$popupContent <- renderPrint(input$text)

    observeEvent(input$togglePopup, {
     f7TogglePopup(id = "popup1")
    })

    observeEvent(input$popup1, {

     popupStatus <- if (input$popup1) "opened" else "closed"

     f7Toast(
      position = "top",
      text = paste("Popup is", popupStatus)
     )
    })
   }
 )
}
}
