% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Slider}
\alias{f7Slider}
\alias{updateF7Slider}
\title{Framework7 range slider}
\usage{
f7Slider(
  inputId,
  label,
  min,
  max,
  value,
  step = 1,
  scale = FALSE,
  scaleSteps = 5,
  scaleSubSteps = 0,
  vertical = FALSE,
  verticalReversed = FALSE,
  labels = NULL,
  color = NULL,
  noSwipping = TRUE
)

updateF7Slider(
  inputId,
  min = NULL,
  max = NULL,
  value = NULL,
  scale = FALSE,
  scaleSteps = NULL,
  scaleSubSteps = NULL,
  step = NULL,
  color = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{The id of the input object.}

\item{label}{Slider label.}

\item{min}{Slider minimum range.}

\item{max}{Slider maximum range}

\item{value}{Slider value or a vector containing 2 values (for a range).}

\item{step}{Slider increase step size.}

\item{scale}{Slider scale.}

\item{scaleSteps}{Number of scale steps.}

\item{scaleSubSteps}{Number of scale sub steps (each step will be divided by this value).}

\item{vertical}{Whether to apply a vertical display. FALSE by default.}

\item{verticalReversed}{Makes vertical range slider reversed (vertical must be also enabled).
FALSE by default.}

\item{labels}{Enables additional label around range slider knob. List of 2 \link{f7Icon}
expected.}

\item{color}{See \link{getF7Colors} for valid colors.}

\item{noSwipping}{Prevent swiping when slider is manipulated in a \code{\link{f7TabLayout}}.}

\item{session}{The Shiny session object.}
}
\description{
\link{f7Slider} creates a f7 slider input.

\link{updateF7Slider} changes the value of a slider input on the client.
}
\note{
labels option only works when vertical is FALSE!

Important: you cannot transform a range slider into a simple slider and inversely.
}
\examples{
# Slider input
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
    title = "My app",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Slider"),
     f7Card(
      f7Slider(
       inputId = "obs",
       label = "Number of observations",
       max = 1000,
       min = 0,
       value = 100,
       scaleSteps = 5,
       scaleSubSteps = 3,
       scale = TRUE,
       color = "orange",
       labels = tagList(
        f7Icon("circle"),
        f7Icon("circle_fill")
       )
      ),
      verbatimTextOutput("test")
     ),
     plotOutput("distPlot")
    )
   ),
   server = function(input, output) {
    output$test <- renderPrint({input$obs})
    output$distPlot <- renderPlot({
     hist(rnorm(input$obs))
    })
   }
 )
}

# Create a range
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
    title = "My app",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Slider Range"),
     f7Card(
      f7Slider(
       inputId = "obs",
       label = "Range values",
       max = 500,
       min = 0,
       value = c(50, 100),
       scale = FALSE
      ),
      verbatimTextOutput("test")
     )
    )
   ),
   server = function(input, output) {
    output$test <- renderPrint({input$obs})
   }
 )
}

# Update f7Slider
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
     title = "My app",
     f7SingleLayout(
       navbar = f7Navbar(title = "updateF7Slider"),
       f7Card(
         f7Button(inputId = "update", label = "Update slider"),
         f7Slider(
           inputId = "obs",
           label = "Range values",
           max = 500,
           min = 0,
           step = 1,
           color = "deeppurple",
           value = c(50, 100)
         ),
         verbatimTextOutput("test")
       )
     )
   ),
   server = function(input, output, session) {

     output$test <- renderPrint({input$obs})

     observeEvent(input$update, {
       updateF7Slider(
         inputId = "obs",
         value = c(1, 5),
         min = 0,
         scaleSteps = 10,
         scaleSubSteps = 5,
         step = 0.1,
         max = 10,
         color = "teal"
       )
     })
   }
 )
}
}
