% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-tabs.R
\name{removeF7Tab}
\alias{removeF7Tab}
\title{Framework7 tab deletion}
\usage{
removeF7Tab(id, target, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{id}{\link{f7Tabs} id.}

\item{target}{\link{f7Tab} to remove.}

\item{session}{Shiny session object.}
}
\description{
\code{removeF7Tab} removes an \link{f7Tab} in a \link{f7Tabs}.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 ui <- f7Page(
  title = "Remove a tab",
  f7TabLayout(
   panels = tagList(
     f7Panel(title = "Left Panel", side = "left", theme = "light", "Blabla", effect = "cover"),
     f7Panel(title = "Right Panel", side = "right", theme = "dark", "Blabla", effect = "cover")
   ),
   navbar = f7Navbar(
     title = "Tabs",
     hairline = FALSE,
     shadow = TRUE,
     leftPanel = TRUE,
     rightPanel = TRUE
   ),
   f7Tabs(
     id = "tabset1",
     f7Tab(
       tabName = "Tab 1",
       active = TRUE,
       p("Text 1"),
       f7Button("remove1","Remove tab 1")
     ),
     f7Tab(
       tabName = "Tab 2",
       active = FALSE,
       p("Text 2")
     ),
     f7Tab(
       tabName = "Tab 3",
       active = FALSE,
       p("Text 3")
     )
   )
  )
 )

 server <- function(input, output, session) {
   observe(print(input$tabset1))
   observeEvent(input$remove1, {
     removeF7Tab(
       id = "tabset1",
       target = "Tab 1"
     )
   })
 }
 shinyApp(ui, server)
}
}
