% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Accordion.R
\name{f7Accordion}
\alias{f7Accordion}
\alias{f7AccordionItem}
\alias{updateF7Accordion}
\title{Framework7 accordion container}
\usage{
f7Accordion(
  ...,
  id = NULL,
  multiCollapse = deprecated(),
  side = c("right", "left")
)

f7AccordionItem(..., title = NULL, open = FALSE)

updateF7Accordion(
  id,
  selected = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{...}{Item content such as \link{f7Block} or any f7 element.}

\item{id}{Accordion instance.}

\item{multiCollapse}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}:
removed from Framework7.}

\item{side}{Accordion collapse toggle side. Default to right.}

\item{title}{Item title.}

\item{open}{Whether the item is open at start. FALSE by default.}

\item{selected}{Index of item to select.}

\item{session}{Shiny session object}
}
\description{
\code{f7Accordion} creates an interactive accordion container.

\code{f7AccordionItem} is to be inserted in \link{f7Accordion}.

\link{updateF7Accordion} toggles an \link{f7Accordion} on the client.
}
\examples{
library(shiny)
library(shinyMobile)

app <- shinyApp(
  ui = f7Page(
    title = "Accordions",
    f7SingleLayout(
      navbar = f7Navbar("Accordions"),
      f7Segment(f7Button(inputId = "go", "Go")),
      f7Accordion(
        id = "myaccordion1",
        f7AccordionItem(
          title = "Item 1",
          f7Block("Item 1 content"),
          open = TRUE
        ),
        f7AccordionItem(
          title = "Item 2",
          f7Block("Item 2 content")
        )
      )
    )
  ),
  server = function(input, output, session) {
    observeEvent(input$go, {
      updateF7Accordion(id = "myaccordion1", selected = 2)
    })
  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
