% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Login.R
\name{f7Login}
\alias{f7Login}
\alias{f7LoginServer}
\alias{updateF7Login}
\title{Framework7 login screen}
\usage{
f7Login(
  ...,
  id,
  title,
  label = "Sign In",
  footer = NULL,
  startOpen = TRUE,
  cancellable = FALSE
)

f7LoginServer(id, ignoreInit = FALSE, trigger = NULL)

updateF7Login(
  id = deprecated(),
  user = NULL,
  password = NULL,
  cancel = FALSE,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{...}{Slot for inputs like password, text, ...}

\item{id}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}.}

\item{title}{Login page title.}

\item{label}{Login confirm button label.}

\item{footer}{Optional footer.}

\item{startOpen}{Whether to open the login page at start. Default to TRUE. There
are some cases where it is interesting to set up to FALSE, for instance when you want
to have authentication only in a specific tab of your app (See example 2).}

\item{cancellable}{Whether to show a cancel button to close the login modal. Default
to FALSE.}

\item{ignoreInit}{If TRUE, then, when this observeEvent is first
created/initialized, ignore the handlerExpr (the second argument),
whether it is otherwise supposed to run or not. The default is FALSE.}

\item{trigger}{Reactive trigger to toggle the login page state. Useful, when
one wants to set up local authentication (for a specific section). See example 2.}

\item{user}{Value of the user input.}

\item{password}{Value of the password input.}

\item{cancel}{Whether to close the login. Default to FALSE.}

\item{session}{Shiny session object.}
}
\description{
Provide a UI template for authentication

\code{f7LoginServer} is demonstration module to test the
\link{f7Login} page. We do not recommend using it in production,
since there is absolutely no security over the passed credentials.
On the JS side, the login is closed as soon as a user and password
are provided but no validity checks are made.

\code{updateF7Login} toggles a login page.
}
\note{
There is an input associated with the login status, namely \code{input$login}.
It is linked to an action button, \code{input$submit}, which is 0 when the application starts. As soon
as the button is pressed, its value is incremented which may be used to call
\link{updateF7Login}. \code{input$user} and \code{input$password} contains values passed
by the user in these respective fields and can be forwarded to \link{updateF7Login}.
\code{input$cancel} is increment whenever the login is closed when cancellable. You can access
the value and trigger other actions on the server, as shown in \link{f7LoginServer}.
}
\examples{
library(shiny)
library(shinyMobile)

app <- shinyApp(
  ui = f7Page(
    title = "Login module",
    f7SingleLayout(
      navbar = f7Navbar(
        title = "Login Example"
      ),
      toolbar = f7Toolbar(
        position = "bottom",
        f7Link(label = "Link 1", href = "https://www.google.com"),
        f7Link(label = "Link 2", href = "https://www.google.com")
      ),
      f7Login(id = "login", title = "Welcome", cancellable = TRUE),
      # main content
      f7BlockTitle(
        title = HTML(paste("Welcome", textOutput("user"))),
        size = "large"
      )
    )
  ),
  server = function(input, output, session) {
    loginData <- f7LoginServer(id = "login")

    exportTestValues(
      status = loginData$status(),
      user = loginData$user(),
      password = loginData$password(),
      authenticated = loginData$authenticated(),
      cancelled = loginData$cancelled()
    )

    output$user <- renderText({
      req(loginData$user)
      loginData$user()
    })
  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
}
