% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anim.R
\name{addHoverAnim}
\alias{addHoverAnim}
\title{Add animation on mouse hover for UI element.}
\usage{
addHoverAnim(session, id, type = NULL)
}
\arguments{
\item{session}{The session object passed to function given to shinyServer.}

\item{id}{the id of the UI element for which you want animation on mouse hover.}

\item{type}{The type of animation to use, valid values correspond to the types in \url{https://daneden.github.io/animate.css/}}
}
\description{
Add animation on mouse hover for UI element.
}
\examples{
if(interactive()){
library(shiny)
library(shinyanimate)
ui <- fluidPage(
  withAnim(),
    tags$div(id = 'title', h1('HOVER ON ME'))
    )
server <- function(input, output, session){
  observe(addHoverAnim(session, 'title', 'bounce'))
 }
shinyApp(ui, server)
}
}
\seealso{
\code{\link{withAnim}}
}
