% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/busy-spinner.R
\name{manual-spinner}
\alias{manual-spinner}
\alias{use_busy_spinner}
\alias{show_spinner}
\alias{hide_spinner}
\title{Manual busy indicator (spinner)}
\usage{
use_busy_spinner(
  spin = "double-bounce",
  color = "#112446",
  position = c("top-right", "top-left", "bottom-right", "bottom-left", "full-page"),
  margins = c(10, 10),
  spin_id = NULL,
  height = "50px",
  width = "50px"
)

show_spinner(spin_id = NULL, session = shiny::getDefaultReactiveDomain())

hide_spinner(spin_id = NULL, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{spin}{Style of the spinner, see \code{\link{spin_epic}} or \code{\link{spin_kit}}
for possible choices. Note that for \code{spin_epic}, height and width are ignored.}

\item{color}{Color for the spinner, in a valid CSS format.}

\item{position}{Where to display the spinner: \code{'top-right'}, \code{'top-left'}, \code{'bottom-right'},
\code{'bottom-left'}, \code{'full-page'}.}

\item{margins}{Distance from margins, a vector of length two, where first element is distance from top/bottom,
second element distance from right/left.}

\item{spin_id}{An explicit id for the spinner, useful if you want to use multiple spinners.}

\item{height}{Height and width of the spinner, default to \code{'50px'} for both, must be specified.}

\item{width}{Height and width of the spinner, default to \code{'50px'} for both, must be specified.}

\item{session}{Shiny session.}
}
\description{
Declare \code{use_busy_spinner} in your UI and show/hide
server-side with \code{show_spinner}/\code{hide_spinner}.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinybusy)

  ui <- fluidPage(

    # Use this function somewhere in UI
    use_busy_spinner(spin = "fading-circle"),

    headerPanel('Iris k-means clustering'),

    sidebarLayout(
      sidebarPanel(
        selectInput('xcol', 'X Variable', names(iris)),
        selectInput('ycol', 'Y Variable', names(iris),
                    selected=names(iris)[[2]]),
        numericInput('clusters', 'Cluster count', 3,
                     min = 1, max = 9),
        actionButton("sleep", "Long calculation")
      ),
      mainPanel(
        plotOutput('plot1')
      )
    )
  )

  server <- function(input, output, session) {

    selectedData <- reactive({
      iris[, c(input$xcol, input$ycol)]
    })

    clusters <- reactive({
      kmeans(selectedData(), input$clusters)
    })

    output$plot1 <- renderPlot({
      palette(c("#E41A1C", "#377EB8", "#4DAF4A", "#984EA3",
                "#FF7F00", "#FFFF33", "#A65628", "#F781BF",
                "#999999"))

      par(mar = c(5.1, 4.1, 0, 1))
      plot(selectedData(),
           col = clusters()$cluster,
           pch = 20, cex = 3)
      points(clusters()$centers, pch = 4, cex = 4, lwd = 4)
    })

    observeEvent(input$sleep, {
      show_spinner()
      Sys.sleep(5)
      hide_spinner()
    })

  }

  shinyApp(ui, server)
}
}
