% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spinners-spinkit.R
\name{spin_kit}
\alias{spin_kit}
\title{SpinKit spinners}
\usage{
spin_kit(
  spin = c("double-bounce", "circle", "bounce", "folding-cube", "rotating-plane",
    "cube-grid", "fading-circle", "dots", "cube"),
  color = "#112446",
  style = NULL
)
}
\arguments{
\item{spin}{Name of the spinner.}

\item{color}{Color of the spinner.}

\item{style}{If not \code{NULL}, add a div container with specified style.}
}
\value{
an HTML tag.
}
\description{
Via \url{https://tobiasahlin.com/spinkit/}.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinybusy)

  ui <- fluidPage(
    tags$h2("SpinKit demo"),
    fluidRow(lapply(
      X = c(
        "circle", "bounce", "folding-cube", "rotating-plane", "cube-grid",
        "fading-circle", "double-bounce", "dots", "cube"
      ),
      FUN = function(x) {
        column(
          width = 2,
          tags$b(x),
          tags$div(
            style = "width: 60px; height: 60px; position: relative;",
            spin_kit(spin = x)
          )
        )
      }
    ))
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
