% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{attachmentBlock}
\alias{attachmentBlock}
\title{AdminLTE2 attachment container}
\usage{
attachmentBlock(..., image, title = NULL, href = NULL)
}
\arguments{
\item{...}{any element.}

\item{image}{url or path to the image.}

\item{title}{attachment title.}

\item{href}{external link.}
}
\description{
\link{attachmentBlock} create an attachment container, nice to wrap articles...
and insert in a \link{box}.
}
\examples{

# Box with attachmentBlock
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinydashboardPlus)
 
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     box(
      title = "Attachment example",
      attachmentBlock(
       image = "https://adminlte.io/themes/AdminLTE/dist/img/photo1.png",
       title = "Test",
       href = "https://google.com",
       "This is the content"
      )
     )
    ),
    title = "AttachmentBlock"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
