% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrinkDSM.R
\name{shrinkDSM}
\alias{shrinkDSM}
\title{Markov Chain Monte Carlo (MCMC) for time-varying parameter survival models with shrinkage}
\usage{
shrinkDSM(
  formula,
  data,
  mod_type = "double",
  delta,
  S,
  group,
  subset,
  niter = 10000,
  nburn = round(niter/2),
  nthin = 1,
  learn_a_xi = TRUE,
  learn_a_tau = TRUE,
  a_xi = 0.1,
  a_tau = 0.1,
  learn_c_xi = TRUE,
  learn_c_tau = TRUE,
  c_xi = 0.1,
  c_tau = 0.1,
  a_eq_c_xi = FALSE,
  a_eq_c_tau = FALSE,
  learn_kappa2_B = TRUE,
  learn_lambda2_B = TRUE,
  kappa2_B = 20,
  lambda2_B = 20,
  hyperprior_param,
  sv_param,
  MH_tuning,
  display_progress = TRUE
)
}
\arguments{
\item{formula}{an object of class "formula": a symbolic representation of the model, as in the
function \code{lm}. For details, see \code{\link{formula}}.}

\item{data}{\emph{optional} data frame containing the response variable and the covariates. If not found in \code{data},
the variables are taken from \code{environment(formula)}, typically the environment from which \code{shrinkDSM}
is called. No \code{NA}s are allowed in the response variable and the covariates.}

\item{mod_type}{character string that reads either \code{"triple"}, \code{"double"} or \code{"ridge"}.
Determines whether the triple gamma, double gamma or ridge prior are used for \code{theta_sr} and \code{beta_mean}.
The default is "double".}

\item{delta}{The status indicator of the last period, 0=censored or 1=event observed.}

\item{S}{integer vector of time points that start a new interval.
Parameters are fixed within an interval and vary across intervals.}

\item{group}{\emph{optional} grouping indicator for latent factor.}

\item{subset}{\emph{optional} vector specifying a subset of observations to be used in the fitting process.}

\item{niter}{positive integer, indicating the number of MCMC iterations
to perform, including the burn-in. Has to be larger than or equal to \code{nburn} + 2. The default value is 10000.}

\item{nburn}{non-negative integer, indicating the number of iterations discarded
as burn-in. Has to be smaller than or equal to \code{niter} - 2. The default value is \code{round(niter / 2)}.}

\item{nthin}{positive integer, indicating the degree of thinning to be performed. Every \code{nthin} draw is kept and returned.
The default value is 1, implying that every draw is kept.}

\item{learn_a_xi}{logical value indicating whether to learn a_xi, the spike parameter of the state variances.
The default value is \code{TRUE}.}

\item{learn_a_tau}{logical value indicating whether to learn a_tau, the spike parameter of the mean of the
initial values of the states. The default value is \code{TRUE}.}

\item{a_xi}{positive, real number, indicating the (fixed) value for a_xi. Ignored if
\code{learn_a_xi} is \code{TRUE} or \code{mod_type} is set to \code{"ridge"}. The default value is 0.1.}

\item{a_tau}{positive, real number, indicating the (fixed) value for a_tau. Ignored if
\code{learn_a_tau} is \code{TRUE} or \code{mod_type} is set to \code{"ridge"}. The default value is 0.1.}

\item{learn_c_xi}{logical value indicating whether to learn c_xi, the tail parameter of the state variances.
Ignored if \code{mod_type} is not set to \code{"triple"} or \code{a_eq_c_xi} is set to \code{TRUE}.
The default value is \code{TRUE}.}

\item{learn_c_tau}{logical value indicating whether to learn c_tau, the tail parameter of the mean of the
initial values of the states. Ignored if \code{mod_type} is not set to \code{"triple"} or \code{a_eq_c_tau} is set to \code{TRUE}.
The default value is \code{TRUE}.}

\item{c_xi}{positive, real number, indicating the (fixed) value for c_xi. Ignored if
\code{learn_c_xi} is \code{TRUE}, \code{mod_type} is not set to \code{"triple"} or \code{a_eq_c_xi} is set to \code{TRUE}.
The default value is 0.1.}

\item{c_tau}{positive, real number, indicating the (fixed) value for c_tau. Ignored if
\code{learn_c_xi} is \code{TRUE}, \code{mod_type} is not set to \code{"triple"}  or \code{a_eq_c_tau} is set to \code{TRUE}.
The default value is 0.1.}

\item{a_eq_c_xi}{logical value indicating whether to force \code{a_xi} and \code{c_xi} to be equal.
If set to \code{TRUE}, \code{beta_a_xi} and \code{alpha_a_xi} are used as the hyperparameters and \code{beta_c_xi} and \code{alpha_c_xi} are ignored.
Ignored if \code{mod_type} is not set to \code{"triple"}. The default value is \code{FALSE}.}

\item{a_eq_c_tau}{logical value indicating whether to force \code{a_tau} and \code{c_tau} to be equal.
If set to \code{TRUE}, \code{beta_a_tau} and \code{alpha_a_tau} are used as the hyperparameters and \code{beta_c_tau} and \code{alpha_c_tau} are ignored.
Ignored if \code{mod_type} is not set to \code{"triple"}. The default value is \code{FALSE}.}

\item{learn_kappa2_B}{logical value indicating whether to learn kappa2_B, the global level of shrinkage for
the state variances. The default value is \code{TRUE}.}

\item{learn_lambda2_B}{logical value indicating whether to learn the lambda2_B parameter,
the global level of shrinkage for the mean of the initial values of the states. The default value is \code{TRUE}.}

\item{kappa2_B}{positive, real number. Initial value of kappa2_B. The default value is 20.}

\item{lambda2_B}{positive, real number. Initial value of lambda2_B. The default value is}

\item{hyperprior_param}{\emph{optional} named list containing hyperparameter values.
Not all have to be supplied, with those missing being replaced by the default values.
Any list elements that are misnamed will be ignored and a warning will be thrown.
All hyperparameter values have to be positive, real numbers. The following hyperparameters can be
supplied:
\itemize{
\item \code{e1}: The default value is 0.001.
\item \code{e2}: The default value is 0.001.
\item \code{d1}: The default value is 0.001.
\item \code{d2}: The default value is 0.001.
\item \code{beta_a_xi}: The default value is 10.
\item \code{beta_a_tau}: The default value is 10.
\item \code{alpha_a_xi}: The default value is 5.
\item \code{alpha_a_tau}: The default value is 5.
}}

\item{sv_param}{\emph{optional} named list containing hyperparameter values for the stochastic volatility
parameters. Not all have to be supplied, with those missing being replaced by the default values.
Any list elements that are misnamed will be ignored and a warning will be thrown. Ignored if
\code{group} is missing. The following elements can be supplied:
\itemize{
\item \code{Bsigma_sv}: positive, real number. The default value is 1.
\item \code{a0_sv}: positive, real number. The default value is 5.
\item \code{b0_sv}: positive, real number. The default value is 1.5.
}}

\item{MH_tuning}{\emph{optional} named list containing values used to tune the MH steps for \code{a_xi} and \code{a_tau}. Not all have to be supplied, with those missing being replaced by the default values.
Any list elements that are misnamed will be ignored and a warning will be thrown.
The arguments for \code{a_xi}(\code{a_tau}) are only used if \code{learn_a_xi}(\code{learn_a_tau})
is set to \code{TRUE}. Arguments ending in "adaptive" are
logical values indicating whether or not to make the MH step for the respective parameter adaptive. Arguments ending in "tuning_par" serve two different purposes.
If the respective MH step is not set to be adaptive, it acts as the standard deviation of the proposal distribution. If the respective MH step
is set to be adaptive, it acts as the initial standard deviation. Arguments ending in "target_rate" define the acceptance rate the algorithm aims to achieve.
Arguments ending in "max_adapt" set the maximum value by which the logarithm of the standard deviation of the proposal distribution is adjusted. Finally,
arguments ending in "batch_size" set the batch size after which the standard deviation of the proposal distribution is adjusted.
The following elements can be supplied:
\itemize{
\item \code{a_xi_adaptive}: logical value. The default is \code{TRUE}.
\item \code{a_xi_tuning_par}: positive, real number. The default value is 1.
\item \code{a_xi_target_rate}: positive, real number, between 0 and 1. The default value is 0.44.
\item \code{a_xi_max_adapt}: positive, real number. The default value is 0.01.
\item \code{a_xi_batch_size}: positive integer. The default value is 50.
\item \code{a_tau_adaptive}: logical value. The default is \code{TRUE}.
\item \code{a_tau_tuning_par}: positive, real number. The default value is 1.
\item \code{a_tau_target_rate}: positive, real number, between 0 and 1. The default value is 0.44.
\item \code{a_tau_max_adapt}: positive, real number. The default value is 0.01.
\item \code{a_tau_batch_size}: positive integer. The default value is 50.
}}

\item{display_progress}{logical value indicating whether the progress bar and other informative output should be
displayed. The default value is \code{TRUE}.}
}
\value{
The value returned is a list object of class \code{shrinkDSM} containing
\item{\code{beta}}{\code{list} object containing an \code{mcmc.dsm.tvp} object for the parameter draws from the posterior distribution of the centered
states, one for each covariate. In the case that there is only one covariate, this becomes just a single \code{mcmc.dsm.tvp} object.}
\item{\code{beta_mean}}{\code{mcmc} object containing the parameter draws from the posterior distribution of beta_mean.}
\item{\code{theta_sr}}{\code{mcmc} object containing the parameter draws from the posterior distribution of the square root of theta.}
\item{\code{tau2}}{\code{mcmc} object containing the parameter draws from the posterior distribution of tau2.}
\item{\code{xi2}}{\code{mcmc} object containing the parameter draws from the posterior distribution of xi2.}
\item{\code{lambda2}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of lambda2.
Not returned if \code{mod_type} is not \code{"triple"}.}
\item{\code{kappa2}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of kappa2.
Not returned if \code{mod_type} is not \code{"triple"}.}
\item{\code{a_xi}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of a_xi.
Not returned if \code{learn_a_xi} is \code{FALSE} or \code{mod_type} is \code{"ridge"}.}
\item{\code{a_tau}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of a_tau.
Not returned if \code{learn_a_tau} is \code{FALSE} or \code{mod_type} is \code{"ridge"}.}
\item{\code{c_xi}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of c_xi.
Not returned if \code{learn_c_xi} is \code{FALSE} or \code{mod_type} is not \code{"triple"}.}
\item{\code{c_tau}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of c_tau.
Not returned if \code{learn_c_tau} is \code{FALSE} or \code{mod_type} is not \code{"triple"}.}
\item{\code{lambda2_B}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of lambda2_B.
Not returned if \code{learn_lambda2_B} is \code{FALSE} or \code{mod_type} is \code{"ridge"}.}
\item{\code{kappa2_B}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of kappa2_B.
Not returned if \code{learn_kappa2_B} is \code{FALSE} or \code{mod_type} is \code{"ridge"}.}
\item{\code{MH_diag}}{\emph{(optional)} named list containing statistics for assessing MH performance. Not returned if no MH steps are required
or none of them are specified to be adaptive.}
\item{\code{priorvals}}{\code{list} object containing hyperparameter values of the prior distributions, as specified by the user.}
\item{\code{model}}{\code{list} object containing the model matrix, model response and formula used.}
\item{\code{summaries}}{\code{list} object containing a collection of summary statistics of the posterior draws.}

To display the output, use \code{plot} and \code{summary}. The \code{summary} method displays the specified prior values stored in
\code{priorvals} and the posterior summaries stored in \code{summaries}, while the \code{plot} method calls \code{coda}'s \code{plot.mcmc}
or the \code{plot.mcmc.dsm.tvp} method. Furthermore, all functions that can be applied to \code{coda::mcmc} objects
(e.g. \code{coda::acfplot}) can be applied to all output elements that are \code{coda} compatible.
}
\description{
\code{shrinkDSM} samples from the joint posterior distribution of the parameters of a time-varying
parameter survival model with shrinkage and returns the MCMC draws.
See also \code{\link{shrinkTVP}} to see more examples of how to modify the prior setup of the time-varying
component of the model.
}
\examples{
\donttest{
set.seed(123)
data("gastric")

# Create intervals for piecewise exponential model
intervals <- divisionpoints(gastric$time, gastric$status, 2)

# Estimate baseline model
mod <- shrinkDSM(time ~ radiation, gastric,
                 delta = gastric$status, S = intervals)

# Estimate model with different prior setup
mod2 <- shrinkDSM(time ~ radiation, gastric,
                 delta = gastric$status, S = intervals,
                 mod_type = "triple")

# Change some of the hyperparameters
mod3 <- shrinkDSM(time ~ radiation, gastric,
                 delta = gastric$status, S = intervals,
                 mod_type = "triple",
                 hyperprior_param = list(beta_a_xi = 5,
                                         alpha_a_xi = 10))
}
}
