% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_funs.R
\name{eval_pred_dens}
\alias{eval_pred_dens}
\title{Evaluate the one-step ahead predictive density of a fitted TVP model}
\usage{
eval_pred_dens(x, mod, data_test, log = FALSE)
}
\arguments{
\item{x}{a real number or a vector of real numbers, taken to be the points at which the predictive density will be evaluated.}

\item{mod}{an object of class \code{shrinkTVP}, containing the fitted model for which the predictive density should be evaluated.}

\item{data_test}{a data frame with one row, containing the one-step ahead covariates. The names of the covariates have to match the
names of the covariates used during model estimation in the call to \code{shrinkTVP}.}

\item{log}{a single logical value detrmining whether the density should be evaluated on the log scale or not.}
}
\value{
The value returned is a vector of length \code{length(x)}, containing the values of the predictive density evaluated
at the points supplied in \code{x}.
}
\description{
\code{eval_pred_dens} evaluates the one-step ahead predictive density of a fitted TVP model resulting from a call to
shrinkTVP at the points supplied in \code{x}. For details on the approximation of the one-step ahead predictive density used,
see the vignette.
}
\examples{
\donttest{
# Simulate data
set.seed(123)
sim <- simTVP(theta = c(0.2, 0, 0), beta_mean = c(1.5, -0.3, 0))
data <- sim$data

# Estimate model
res <- shrinkTVP(y ~ x1 + x2, data = data[1:199, ])

# Create sequence of x values where the density is to be evaluated
x_vals <- seq(0, 12, by = 0.1)

# Evaluate density and plot
dens <- eval_pred_dens(x_vals, res, data[200, ])
plot(x_vals, dens, type = "l")

# Add vertical line where true value of the one-step ahead y lies
abline(v = data$y[200])
}
}
\seealso{
Other prediction functions: 
\code{\link{LPDS}()},
\code{\link{fitted.shrinkTVP}()},
\code{\link{forecast_shrinkTVP}()},
\code{\link{predict.shrinkTVP}()},
\code{\link{residuals.shrinkTVP}()}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
\concept{prediction functions}
