% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_query_from_token.R
\name{get_query_from_token}
\alias{get_query_from_token}
\title{Get Query From Token}
\usage{
get_query_from_token(query_token, api_key, page_number = 1, page_size = 1e+05)
}
\arguments{
\item{query_token}{token from `create_query_token()`}

\item{api_key}{Flipside Crypto ShroomDK API Key}

\item{page_number}{Query tokens are cached and 100k rows max. Get up to 1M rows by going through pages.}

\item{page_size}{Default 100,000. Paginate via page_number.}
}
\value{
returns a request of length 8: `results`, `columnLabels`,
 `columnTypes`, `startedAt`, `endedAt`, `pageNumber`, `pageSize`, `status`
}
\description{
Uses Flipside ShroomDK to access a Query Token. Query tokens are cached up to `ttl` minutes
for each `query`. This function is for pagination and multiple requests
while . Note: To reduce payload it returns
a list of outputs (separating column names from rows).
}
\examples{
\dontrun{
query = create_query_token("SELECT * FROM ETHEREUM.CORE.FACT_TRANSACTIONS LIMIT 10000", api_key)
get_query_from_token(query$token, api_key, 1, 10000)
}
}
