% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sig_feature_association.R
\name{get_sig_feature_association}
\alias{get_sig_feature_association}
\title{Calculate Association between Signature Exposures and Other Features}
\usage{
get_sig_feature_association(
  data,
  cols_to_sigs,
  cols_to_features,
  type = "ca",
  method_co = c("spearman", "pearson", "kendall"),
  method_ca = stats::wilcox.test,
  min_n = 0.01,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{a \code{data.frame} contains signature exposures and other features}

\item{cols_to_sigs}{colnames for signature exposure}

\item{cols_to_features}{colnames for other features}

\item{type}{a character vector containing 'ca' for categorical variable and 'co' for continuous variable,
it must have the same length as \code{cols_to_features}.}

\item{method_co}{method for continuous variable, default is "spearman", could also be "pearson" and "kendall".}

\item{method_ca}{method for categorical variable, default is "wilcox.test"}

\item{min_n}{a minimal fraction (e.g. 0.01) or a integer number (e.g. 10) for filtering some variables with few positive events.
Default is 0.01.}

\item{verbose}{if \code{TRUE}, print extra message.}

\item{...}{other arguments passing to test functions, like \code{cor.test}.}
}
\value{
a \code{list}. For 'co' features, 'measure' means correlation coefficient.
For 'ca' features, 'measure' means difference in means of signature exposure.
}
\description{
Association of signature exposures with other features will be performed using one of two procedures:
for a continuous association variable (including ordinal variable), correaltion is performed;
for a binary association variable, samples will be divided into two groups and Mann-Whitney U-test
is performed to test for differences in signature exposure medians between the two groups.
See \link{get_tidy_association} for cleaning association result.
}
\seealso{
\link{get_tidy_association}
}
