% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_labels.R
\name{add_labels}
\alias{add_labels}
\title{Add Text Labels to a ggplot}
\usage{
add_labels(
  p,
  x,
  y,
  y_end = NULL,
  n_label = NULL,
  labels = NULL,
  revert_order = FALSE,
  font_size = 5,
  font_family = "serif",
  font_face = c("plain", "bold", "italic"),
  ...
)
}
\arguments{
\item{p}{a \code{ggplot}.}

\item{x}{position at x axis.}

\item{y}{position at y axis.}

\item{y_end}{end position of y axis when \code{n_label} is set.}

\item{n_label}{the number of label, when this is set,
the position of labels at y axis is auto-generated
according to \code{y} and \code{y_end}.}

\item{labels}{text labels or a \code{similarity} object from \link{get_sig_similarity}.}

\item{revert_order}{if \code{TRUE}, revert label order.}

\item{font_size}{font size.}

\item{font_family}{font family.}

\item{font_face}{font face.}

\item{...}{other parameters passing to \link[ggplot2:annotate]{ggplot2::annotate}.}
}
\value{
a \code{ggplot} object.
}
\description{
Add text labels to a ggplot object, such as the result
from \link{show_sig_profile}.
}
\examples{
# Load mutational signature
load(system.file("extdata", "toy_mutational_signature.RData",
  package = "sigminer", mustWork = TRUE
))
# Show signature profile
p <- show_sig_profile(sig2, mode = "SBS")

# Method 1
p1 <- add_labels(p,
  x = 0.75, y = 0.3, y_end = 0.9, n_label = 3,
  labels = paste0("text", 1:3)
)
p1

# Method 2
p2 <- add_labels(p,
  x = c(0.15, 0.6, 0.75), y = c(0.3, 0.6, 0.9),
  labels = paste0("text", 1:3)
)
p2

# Method 3
sim <- get_sig_similarity(sig2)
p3 <- add_labels(p,
  x = c(0.15, 0.6, 0.75), y = c(0.25, 0.55, 0.8),
  labels = sim, font_size = 2
)
p3
}
