% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{optimize_cor_for_pair}
\alias{optimize_cor_for_pair}
\title{Find pairwise initial correlation for NORTA from target correlation}
\usage{
optimize_cor_for_pair(
  cor_target,
  dist1,
  dist2,
  n_obs = 1e+05,
  seed = NULL,
  tol = 0.01,
  ...
)
}
\arguments{
\item{cor_target}{Target correlation of variable pair.}

\item{dist1, dist2}{Marginal distributions of variable pair, given as univariable quantile
functions.}

\item{n_obs}{Number of observations to be used in the numerical optimization procedure.}

\item{seed}{Seed for generating standard normal random variables in the numerical
optimization procedure.}

\item{tol, ...}{Further parameters passed to \code{\link[stats:uniroot]{stats::uniroot}}.}
}
\value{
Output of \code{\link[stats:uniroot]{stats::uniroot}} for the univariable
optimization for find the initial correlation.
}
\description{
This function can be used to find a suitable initial correlation for use
in the NORTA procedure for a pair of variables with given marginal
distributions and target correlation.
}
\details{
Uses \code{\link[stats:uniroot]{stats::uniroot}} for actual optimization.
}
