% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fin_statements.R
\name{simfinR_get_fin_statements}
\alias{simfinR_get_fin_statements}
\title{Get financial statements from simfin}
\usage{
simfinR_get_fin_statements(
  id_companies,
  api_key,
  type_statements = c("pl", "bs", "cf"),
  periods = "FY",
  years = 2018,
  cache_folder = "simfin_cache"
)
}
\arguments{
\item{id_companies}{Simfin Id of companies to get data (see \code{\link{simfinR_get_available_companies}} for details)}

\item{api_key}{Your api key (get one at <https://simfin.com/data/access/api>)}

\item{type_statements}{Types of financial statements ('pl' - profit loss, 'bs' - balance sheet, 'cf' - cashflow)}

\item{periods}{Time periods to grab the data ('FY' - final year, 'Q1' - first quarter, 'Q2', 'Q3', 'Q4')}

\item{years}{The years to grab data (vector or single value)}

\item{cache_folder}{Directory for cache files}
}
\value{
A dataframe with financial statements
}
\description{
Uses the simfim api <https://simfin.com/> for downloading corporate financial datasets available at the website.
In order to use the function, you'll need a valid api key from <https://simfin.com/data/access/api>.
All data from the site is locally cached with package memoise, meaning it will never grab repeated data from the api.
}
\examples{
\dontrun{
id_companies <- 59265
api_key <- 'YOURAPIHERE'

df_fin <- get_fin_statements(id_companies, api_key = api_key)
}
}
