% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{strength}
\alias{strength}
\title{Vertex strength: sum of weights of incident edges}
\usage{
strength(graph, mode = c("out", "in", "total", "all"))
}
\arguments{
\item{graph}{Input graph.}

\item{mode}{Whether to consider incoming (\code{in}),
outgoing (\code{out}) or all (\code{total}) edges.}
}
\value{
Named numeric vector.
}
\description{
This is also called weighed degree.
}
\details{
For non-weighted graphs, the degree is returned as a
fallback.
}
\examples{
G <- graph(
  data.frame(
    stringsAsFactors = FALSE,
    id = c("a", "b", "c", "d")
  ),
  data.frame(
    stringsAsFactors = FALSE,
    from   = c("a", "a", "b", "b", "c"),
    to     = c("b", "d", "d", "c", "a"),
    weight = c( 1 ,  2 ,  1 ,  3 ,  2 )
  )
)
strength(G)

G2 <- graph(
  data.frame(
    stringsAsFactors = FALSE,
    id = c("a", "b", "c", "d")
  ),
  data.frame(
    stringsAsFactors = FALSE,
    from   = c("a", "a", "b", "b", "c"),
    to     = c("b", "d", "d", "c", "a")
  )
)
strength(G2)
}

