% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MmSimplex.R
\name{MmSimplex}
\alias{MmSimplex}
\title{Maxmin Simplex Design}
\usage{
MmSimplex(k,N,l,cords = 1, randst = 1, phival = 50, tol = 0.0001)
}
\arguments{
\item{k}{Number of factors in the design}

\item{N}{Number of experimental runs}

\item{l}{Number of levels for the search grid}

\item{cords}{Number of coordinates to exchange simultaneously using an exchange algorithm}

\item{randst}{Number of random starts to the design}

\item{phival}{Value of p in the PhiP criterion}

\item{tol}{Tolerance of the optimization, the value for which an improvement smaller than this ends the optimization}
}
\value{
\describe{
\item{D1}{The optimal design among the random starts standardized to [0,1]}
\item{phival}{The phiP value of the design}
\item{phistore}{A vector of phiP values from each random start}
}
}
\description{
Constructs a Maximin space-filling design on a k-dimensional simplex.
}
\details{
This function applies a coordinate-exchange algorithm to optimize the Maximin distance criterion for a simplex.
A maximin design maximizes the minimum interpoint distance and is one commonly used space-filling criterion.  We do not optimize this criterion directly, but rather optimizes \deqn{ \phi_p = ( \sum\sum d_{ij}^{-p})^{1/p} }
This is done for optimization purposes since it is a smoother criteria.
}
\examples{
## Generate Design
time1 <- Sys.time()
D1 <- MmSimplex(5,40,10,cords = 1,randst = 2,phival = 50)
Sys.time() - time1

##View best design scaled to [0,1]^5
D1[[1]]

##View PhiP criterion for best design among 2 random starts
D1[[2]]

}
\references{
\itemize{
 \item Johnson, M. E., L. M. Moore, and D. Ylvisaker (1990).  Minimax and maximin distance designs. Journal of statistical planning and inference 26 (2). 131-148.
 \item Meyer, R. K., and C.J. Nachtsheim (1995). The coordinate-exchange algorithm for constructing exact optimal experimental designs. Technometrics 37 (1). 60-69.
}
}
