% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{model_complete}
\alias{model_complete}
\title{Function that takes a lavaan model with standardized paths and loadings and returns a complete lavaan model syntax with standardized variances}
\usage{
model_complete(m)
}
\arguments{
\item{m}{Structural model represented by lavaan syntax}
}
\value{
character string representing lavaan model
}
\description{
Function that takes a lavaan model with standardized paths and loadings and returns a complete lavaan model syntax with standardized variances
}
\examples{
library(simstandard)
# lavaan model
m = "
Latent_1 =~ 0.9 * Ob_11 + 0.8 * Ob_12 + 0.7 * Ob_13
Latent_2 =~ 0.9 * Ob_21 + 0.6 * Ob_22 + 0.4 * Ob_23
Latent_2 ~ 0.6 * Latent_1
"
# Same lavaan syntax, but with standardized variances
m_complete <- model_complete(m)
cat(m_complete)
}
