% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmsd.R
\name{rmsd}
\alias{rmsd}
\title{Root mean square deviation}
\usage{
rmsd(x, y, na.rm = TRUE)
}
\arguments{
\item{x}{The first vector to compare (required).}

\item{y}{The second vector to compare (required).
Lengths of \code{x} and \code{y} must be equal.}

\item{na.rm}{If \code{TRUE} (default), \code{NA} values are removed before calculating the mean square difference.
If \code{FALSE}, any missing values in either \code{x} or \code{y} result in \code{NA} returned.
Passed to \code{\link[=mean]{mean()}}, see that for more info.}
}
\value{
the square root of the mean square difference between \code{x} and \code{y}, after removing \code{NA} comparisons (cases where either is \code{NA}).
}
\description{
Calculates the euclidean distance between two vectors \code{x} and \code{y} divided by the square root of the lengths of the vectors.
\code{NA} values are ignored by default when calculating the mean squares (so the denominator is the number of non-\code{NA} differences).
}
\examples{
x <- rnorm(10)
y <- rnorm(10)
rmsd( x, y )

}
