% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counting_process.R
\name{counting_process}
\alias{counting_process}
\title{Process survival data into counting process format}
\usage{
counting_process(x, arm)
}
\arguments{
\item{x}{A data frame with no missing values and contain variables:
\itemize{
\item \code{stratum}: Stratum.
\item \code{treatment}: Treatment group.
\item \code{tte}: Observed time.
\item \code{event}: Binary event indicator, \code{1} represents event,
\code{0} represents censoring.
}}

\item{arm}{Value in the input \code{treatment} column that indicates
treatment group value.}
}
\value{
A data frame grouped by \code{stratum} and sorted within stratum by \code{tte}.
Remain rows with at least one event in the population, at least one subject
is at risk in both treatment group and control group.
Other variables in this represent the following within each stratum at
each time at which one or more events are observed:
\itemize{
\item \code{events}: Total number of events
\item \code{n_event_tol}: Total number of events at treatment group
\item \code{n_risk_tol}: Number of subjects at risk
\item \code{n_risk_trt}: Number of subjects at risk in treatment group
\item \code{S}: Left-continuous Kaplan-Meier survival estimate
\item \code{o_minus_e}: In treatment group, observed number of events minus expected
number of events. The expected number of events is estimated by assuming
no treatment effect with hypergeometric distribution with parameters total
number of events, total number of events at treatment group and number of
events at a time. (Same assumption of log-rank test under the null
hypothesis)
\item \code{var_o_minus_e}: Variance of \code{o_minus_e} under the same assumption.
}
}
\description{
Produces a data frame that is sorted by stratum and time.
Included in this is only the times at which one or more event occurs.
The output dataset contains stratum, tte (time-to-event),
at risk count and count of events at the specified tte
sorted by stratum and tte.
}
\details{
The function only considered two group situation.

The tie is handled by the Breslow's Method.
}
\examples{
# Example 1
x <- data.frame(
  stratum = c(rep(1, 10), rep(2, 6)),
  treatment = rep(c(1, 1, 0, 0), 4),
  tte = 1:16,
  event = rep(c(0, 1), 8)
)
counting_process(x, arm = 1)

# Example 2
x <- sim_pw_surv(n = 400)
y <- cut_data_by_event(x, 150) |> counting_process(arm = "experimental")
# Weighted logrank test (Z-value and 1-sided p-value)
z <- sum(y$o_minus_e) / sqrt(sum(y$var_o_minus_e))
c(z, pnorm(z))
}
