% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_tabla_incidencia_sex}
\alias{plot_tabla_incidencia_sex}
\title{Generar tabla con la incidencia por sexo}
\usage{
plot_tabla_incidencia_sex(data_agrupada, col_sex = "sexo")
}
\arguments{
\item{data_agrupada}{Un `data.frame` que contiene los datos de la
enfermedad o evento agrupados por departamento o municipio.}

\item{col_sex}{Un `character` (cadena de caracteres) con el nombre de
la columna que contiene el sexo en los datos agrupados de la enfermedad
o evento; su valor por defecto es `"sexo"`.}
}
\value{
Una `kable` (tabla gráfica) con la incidencia por sexo.
}
\description{
Función que genera la tabla con la incidencia por
sexo.
}
\examples{
\donttest{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(data_event = dengue2020)
data_agrupada_sex <- agrupar_sex(data_limpia)
incidencia_mpios <-
  calcular_incidencia_sex(
    data_agrupada = data_agrupada_sex,
    dpto = "Antioquia",
    ruta_dir = tempdir()
  )
plot_tabla_incidencia_sex(
  data_agrupada = incidencia_mpios$data_incidencia,
  col_sex = "sexo"
)
}
}
