\name{sju.groupVar}
\alias{sju.groupVar}
\title{Recode scales into grouped factors}
\usage{
sju.groupVar(var, groupsize = 5, asNumeric = TRUE, rightInterval = FALSE,
  autoGroupCount = 30)
}
\arguments{
  \item{var}{The scale variable, which should recoded into
  groups.}

  \item{groupsize}{The group-size, i.e. the range for
  grouping. By default, for each 5 categories new group is
  built, i.e. \code{groupsize=5}. Use
  \code{groupsize="auto"} to automatically resize a
  variable into a maximum of 30 groups (which is the
  ggplot-default grouping when plotting histograms). Use
  \code{autoGroupCount} to determin the amount of groups.}

  \item{asNumeric}{If \code{TRUE} (default), the recoded
  variable will be returned as numeric vector.  If
  \code{FALSE}, a factor is returned.}

  \item{rightInterval}{If \code{TRUE}, grouping starts with
  the lower bound of \code{groupsize}. In this case, groups
  cover the ranges from 50-54, 55-59, 60-64 etc. \cr If
  \code{FALSE} (default), grouping starts with the upper
  bound of \code{groupsize}. In this case, groups cover the
  ranges from 51-55, 56-60, 61-65 etc.}

  \item{autoGroupCount}{Sets the maximum number of groups
  that are built when auto-grouping is on
  (\code{groupsize="auto"}). Default is 30. If
  \code{groupsize} is not set to \code{"auto"}, this
  parameter will be ignored.}
}
\value{
A grouped variable, either as numeric or as factor (see
paramter \code{asNumeric}).
}
\description{
Recode scales into grouped factors.
}
\examples{
age <- abs(round(rnorm(100, 65, 20)))
age.grp <- sju.groupVar(age, 10)
hist(age)
hist(age.grp)

# histogram with EUROFAMCARE sample dataset
# variable not grouped
data(efc)
efc.val <- sji.getValueLabels(efc)
efc.var <- sji.getVariableLabels(efc)
sjp.frq(efc$e17age,
        title=efc.var[['e17age']],
        type="h",
        showValueLabels=FALSE)

# bar plot with EUROFAMCARE sample dataset
# grouped variable
data(efc)
efc.val <- sji.getValueLabels(efc)
efc.var <- sji.getVariableLabels(efc)
ageGrp <- sju.groupVar(efc$e17age)
ageGrpLab <- sju.groupVarLabels(efc$e17age)
sjp.frq(ageGrp,
        title=efc.var[['e17age']],
        axisLabels.x=ageGrpLab,
        maxYlim=FALSE)
}
\seealso{
\code{\link{sju.groupVarLabels}}
}

