% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjStatistics.R
\name{mwu}
\alias{mwu}
\title{Performs a Mann-Whitney-U-Test}
\usage{
mwu(var, grp, distribution = "asymptotic", weights = NULL)
}
\arguments{
\item{var}{A numeric vector / variable, where the Mann-Whitney-U-Test should be applied to.}

\item{grp}{The grouping variable indicating the groups that should be used for comparison.}

\item{distribution}{indicates how the null distribution of the test statistic should be computed. Mey be one of
\code{exact}, \code{approximate} or \code{asymptotic} (default).
See \code{wilcox_test} (\code{coin}-package) for details.}

\item{weights}{defining integer valued weights for the observations. By default,
this is \code{NULL}.}
}
\value{
(Invisibly) returns a data frame with U, p and Z-values for each group-comparison
        as well as effect-size r.
}
\description{
This function performs a Mann-Whitney-U-Test (or \code{Wilcoxon rank sum test},
               see \code{\link{wilcox.test}} and \code{wilcox_test} (\code{coin}-package)) for the variable \code{var}, which is
               divided into groups indicated by \code{grp} (so the formula \code{var ~ grp}
               is used). If \code{grp} has more than two categories, a comparison between each
               two groups is performed. \cr \cr
               The function reports U, p and Z-values as well as effect size r
               and group-rank-means.
}
\note{
This function calls the \code{wilcox_test} (from the coin package) with formula. If \code{grp}
        has more than two groups, additionally a Kruskal-Wallis-Test (see \code{\link{kruskal.test}})
        is performed. \cr \cr
        Interpretation of effect sizes:
        \itemize{
         \item small effect >= 0.1
         \item medium effect >= 0.3
         \item large effect >= 0.5
       }
}
\examples{
\dontrun{
data(efc)
# Mann-Whitney-U-Tests for elder's age by elder's dependency.
mwu(efc$e17age, efc$e42dep)}
}
\seealso{
\code{\link{chisq_gof}}, \code{\link{levene_test}},
         \code{\link{wilcox.test}}, \code{\link{ks.test}},
         \code{\link{kruskal.test}}, \code{\link{t.test}},
         \code{\link{chisq.test}} and \code{\link{fisher.test}}
}

