% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{to_sjPlot}
\alias{to_sjPlot}
\title{Convert a haven-imported data frame to sjPlot format}
\usage{
to_sjPlot(x)
}
\arguments{
\item{x}{a data frame, which contains \code{labelled} class vectors or a single vector
of class \code{labelled}.}
}
\value{
a data frame or single vector (depending on \code{x}) with 'sjPlot' friendly
          vector classes and attached label attributes.
}
\description{
This function converts
               \itemize{
                 \item a data frame, which was imported with any of \code{haven}'s read functions and contains \code{labelled} class vectors or
                 \item a single vector of type \code{labelled}
               }
               into an sjPlot friendly data frame format. This means, that all \code{labelled} class attributes
               will be removed, so all vectors / variables are now most likely \code{\link{atomic}}, and
               all \code{"label"} and \code{"labels"} attributes are renamed into \code{"value.labels"}
               and \code{"variable.label"} (which corresponds to the \code{forein} format).
}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/datainit/}{sjPlot manual: data initialization}
           }
}

